/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.cli;

import java.util.List;
import org.apache.juddi.api_v3.Node;
import org.apache.juddi.v3.client.cli.JuddiAdminService;
import org.apache.juddi.v3.client.config.UDDIClient;
import org.uddi.api_v3.BusinessList;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.FindQualifiers;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.ServiceList;
import org.uddi.api_v3.TModelList;
import org.uddi.v3_service.UDDIInquiryPortType;

public class EntryPoitMultiNode {
    static void goMultiNode() throws Exception {
        UDDIClient clerkManager = new UDDIClient("META-INF/simple-publish-uddi.xml");
        String input = null;
        do {
            System.out.println("1) Sets undirected replication two instances of jUDDI");
            System.out.println("2) Sets undirected replication 3 instances of jUDDI");
            System.out.println("3) Sets directed replication between 3 instances of jUDDI");
            System.out.println("4) Prints the replication status for all nodes");
            System.out.println("5) Prints the business, service, and tmodels counts");
            System.out.println("6) Ping all nodes");
            System.out.println("q) quit");
            System.out.print("Selection: ");
            input = System.console().readLine();
            EntryPoitMultiNode.processInput(input, clerkManager);
        } while (!input.equalsIgnoreCase("q"));
    }

    private static void processInput(String input, UDDIClient clerkManager) throws Exception {
        if (input.equals("1")) {
            new JuddiAdminService(clerkManager, null).autoMagic();
        } else if (input.equals("2")) {
            new JuddiAdminService(clerkManager, null).autoMagic3();
        } else if (input.equals("3")) {
            new JuddiAdminService(clerkManager, null).autoMagicDirected();
        } else if (input.equals("4")) {
            new JuddiAdminService(clerkManager, null).printStatus();
        } else if (input.equals("5")) {
            List uddiNodeList = clerkManager.getClientConfig().getUDDINodeList();
            for (Node n : uddiNodeList) {
                UDDIInquiryPortType uddiInquiryService = clerkManager.getTransport(n.getName()).getUDDIInquiryService();
                FindBusiness fb = new FindBusiness();
                fb.getName().add(new Name("%", null));
                fb.setFindQualifiers(new FindQualifiers());
                fb.getFindQualifiers().getFindQualifier().add("approximateMatch");
                fb.setMaxRows(Integer.valueOf(1));
                fb.setListHead(Integer.valueOf(0));
                BusinessList findBusiness = uddiInquiryService.findBusiness(fb);
                System.out.println(n.getName() + " business count " + findBusiness.getListDescription().getActualCount());
                FindService fs = new FindService();
                fs.getName().add(new Name("%", null));
                fs.setFindQualifiers(new FindQualifiers());
                fs.getFindQualifiers().getFindQualifier().add("approximateMatch");
                fs.setMaxRows(Integer.valueOf(1));
                fs.setListHead(Integer.valueOf(0));
                ServiceList findService = uddiInquiryService.findService(fs);
                System.out.println(n.getName() + " service count " + findService.getListDescription().getActualCount());
                FindTModel ft = new FindTModel();
                ft.setName(new Name("%", null));
                ft.setFindQualifiers(new FindQualifiers());
                ft.getFindQualifiers().getFindQualifier().add("approximateMatch");
                ft.setMaxRows(Integer.valueOf(1));
                ft.setListHead(Integer.valueOf(0));
                TModelList findTModel = uddiInquiryService.findTModel(ft);
                System.out.println(n.getName() + " tModel count " + findTModel.getListDescription().getActualCount());
            }
            System.out.println();
        } else if (input.equals("6")) {
            new JuddiAdminService(clerkManager, null).pingAll();
        }
    }
}

