/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonlogic.spi;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import javax.json.JsonValue;
import org.apache.johnzon.jsonlogic.JohnzonJsonLogic;
import org.apache.johnzon.jsonlogic.spi.Operator;

@FunctionalInterface
public interface AsyncOperator
extends Operator {
    @Override
    public CompletionStage<JsonValue> applyStage(JohnzonJsonLogic var1, JsonValue var2, JsonValue var3);

    @Override
    default public JsonValue apply(JohnzonJsonLogic logic, JsonValue config, JsonValue params) {
        try {
            return this.applyStage(logic, config, params).toCompletableFuture().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (RuntimeException.class.isInstance(cause)) {
                throw (RuntimeException)RuntimeException.class.cast(cause);
            }
            throw new IllegalStateException(cause);
        }
    }
}

