/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonlogic;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonException;
import javax.json.JsonMergePatch;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonPatch;
import javax.json.JsonPointer;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.spi.JsonProvider;
import org.apache.johnzon.jsonlogic.spi.Operator;

public class JohnzonJsonLogic {
    private final JsonProvider provider;
    private final Map<String, Operator> operators = new HashMap<String, Operator>();
    private final Map<String, JsonPointer> pointers = new ConcurrentHashMap<String, JsonPointer>();
    private final Map<JsonArray, JsonPatch> jsonPatches = new ConcurrentHashMap<JsonArray, JsonPatch>();
    private final Map<JsonValue, JsonMergePatch> jsonMergePatches = new ConcurrentHashMap<JsonValue, JsonMergePatch>();
    private final JsonBuilderFactory builderFactory;
    private boolean cachePointers;
    private boolean cacheJsonPatches;
    private boolean cacheJsonMergePatches;

    public JohnzonJsonLogic() {
        this(JsonProvider.provider());
        this.registerDefaultOperators();
        this.registerExtensionsOperators();
    }

    public JohnzonJsonLogic(JsonProvider provider) {
        this.provider = provider;
        this.builderFactory = provider.createBuilderFactory(Collections.emptyMap());
    }

    public JohnzonJsonLogic cachePointers() {
        this.cachePointers = true;
        return this;
    }

    public JohnzonJsonLogic cacheJsonPatches() {
        this.cacheJsonPatches = true;
        return this;
    }

    public JohnzonJsonLogic cacheJsonMergePatches() {
        this.cacheJsonMergePatches = true;
        return this;
    }

    public JohnzonJsonLogic registerOperator(String name, Operator impl) {
        this.operators.put(name, impl);
        return this;
    }

    public JsonValue apply(JsonValue logic, JsonValue args) {
        if (logic.getValueType() != JsonValue.ValueType.OBJECT) {
            return logic;
        }
        JsonObject object = logic.asJsonObject();
        if (object.size() > 1) {
            return object;
        }
        Set keys = object.keySet();
        if (keys.size() != 1) {
            throw this.invalidArgument(keys);
        }
        String operator = (String)keys.iterator().next();
        Operator impl = this.operators.get(operator);
        if (impl == null) {
            throw this.missingOperator(operator);
        }
        return impl.apply(this, (JsonValue)object.get((Object)operator), args);
    }

    public CompletionStage<JsonValue> applyStage(JsonValue logic, JsonValue args) {
        if (logic.getValueType() != JsonValue.ValueType.OBJECT) {
            return CompletableFuture.completedFuture(logic);
        }
        JsonObject object = logic.asJsonObject();
        if (object.size() > 1) {
            return CompletableFuture.completedFuture(object);
        }
        Set keys = object.keySet();
        if (keys.size() != 1) {
            CompletableFuture<JsonValue> promise = new CompletableFuture<JsonValue>();
            promise.completeExceptionally(this.invalidArgument(keys));
            return promise;
        }
        String operator = (String)keys.iterator().next();
        Operator impl = this.operators.get(operator);
        if (impl == null) {
            CompletableFuture<JsonValue> promise = new CompletableFuture<JsonValue>();
            promise.completeExceptionally(this.missingOperator(operator));
            return promise;
        }
        return impl.applyStage(this, (JsonValue)object.get((Object)operator), args);
    }

    public boolean isTruthy(JsonValue value) {
        return !this.isFalsy(value);
    }

    public boolean isFalsy(JsonValue value) {
        switch (value.getValueType()) {
            case NUMBER: {
                return ((JsonNumber)JsonNumber.class.cast(value)).intValue() == 0;
            }
            case ARRAY: {
                return value.asJsonArray().isEmpty();
            }
            case STRING: {
                return ((JsonString)JsonString.class.cast(value)).getString().isEmpty();
            }
            case FALSE: 
            case NULL: {
                return true;
            }
        }
        return false;
    }

    public boolean areEqualsWithCoercion(JsonValue a, JsonValue b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        if (a.getValueType() == b.getValueType()) {
            return a.equals(b);
        }
        switch (a.getValueType()) {
            case STRING: {
                switch (b.getValueType()) {
                    case NUMBER: {
                        try {
                            return Double.parseDouble(((JsonString)JsonString.class.cast(a)).getString()) == ((JsonNumber)JsonNumber.class.cast(b)).doubleValue();
                        }
                        catch (NumberFormatException nfe) {
                            return false;
                        }
                    }
                    case FALSE: 
                    case TRUE: {
                        return this.isFalsy(a) == this.isFalsy(b);
                    }
                }
                return false;
            }
            case NUMBER: {
                switch (b.getValueType()) {
                    case STRING: {
                        try {
                            return Double.parseDouble(((JsonString)JsonString.class.cast(b)).getString()) == ((JsonNumber)JsonNumber.class.cast(a)).doubleValue();
                        }
                        catch (NumberFormatException nfe) {
                            return false;
                        }
                    }
                }
                return this.isFalsy(a) == this.isFalsy(b);
            }
            case FALSE: 
            case TRUE: {
                return this.isFalsy(a) == this.isFalsy(b);
            }
        }
        return false;
    }

    public JohnzonJsonLogic registerExtensionsOperators() {
        this.registerOperator("jsonpatch", (logic, config, params) -> this.getJsonPatch(config).apply((JsonStructure)JsonStructure.class.cast(params)));
        this.registerOperator("jsonmergepatch", (logic, config, params) -> this.getJsonMergePatch(config).apply(params));
        this.registerOperator("jsonmergediff", (logic, config, params) -> {
            JsonArray array = params.asJsonArray();
            if (array.size() != 2) {
                throw new IllegalArgumentException("jsonmergediff should have 2 parameters (in an array): " + array);
            }
            return this.provider.createMergeDiff(config, (JsonValue)array.get(0)).apply((JsonValue)array.get(1));
        });
        return this;
    }

    private JsonPatch getJsonPatch(JsonValue config) {
        if (!this.cacheJsonPatches) {
            return this.provider.createPatch(config.asJsonArray());
        }
        return this.jsonPatches.computeIfAbsent(config.asJsonArray(), arg_0 -> ((JsonProvider)this.provider).createPatch(arg_0));
    }

    private JsonMergePatch getJsonMergePatch(JsonValue config) {
        if (!this.cacheJsonPatches) {
            return this.provider.createMergePatch(config);
        }
        return this.jsonMergePatches.computeIfAbsent(config, arg_0 -> ((JsonProvider)this.provider).createMergePatch(arg_0));
    }

    public JohnzonJsonLogic registerDefaultOperators() {
        this.registerOperator("log", (logic, config, params) -> {
            throw new UnsupportedOperationException("Log is not supported by default, register the following operator with your preferred logger:\n\njsonLogic.registerOperator(\"log\", (l, c, p) -> log.info(String.valueOf(l.apply(c, p)));\n");
        });
        this.registerOperator("var", (logic, config, params) -> this.varImpl(config, params));
        this.registerOperator("missing", this::missingImpl);
        this.registerOperator("missing_some", this::missingSomeImpl);
        this.registerOperator("if", this::ifImpl);
        this.registerOperator("<", (logic, config, params) -> this.numericComparison((a, b) -> a < b, config, logic, params));
        this.registerOperator(">", (logic, config, params) -> this.numericComparison((a, b) -> a > b, config, logic, params));
        this.registerOperator("<=", (logic, config, params) -> this.numericComparison((a, b) -> a <= b, config, logic, params));
        this.registerOperator(">=", (logic, config, params) -> this.numericComparison((a, b) -> a >= b, config, logic, params));
        this.registerOperator("==", (logic, config, params) -> this.comparison(this::areEqualsWithCoercion, config, logic, params));
        this.registerOperator("!=", (logic, config, params) -> this.comparison((a, b) -> !this.areEqualsWithCoercion((JsonValue)a, (JsonValue)b), config, logic, params));
        this.registerOperator("===", (logic, config, params) -> this.comparison(Objects::equals, config, logic, params));
        this.registerOperator("!==", (logic, config, params) -> this.comparison((a, b) -> !Objects.equals(a, b), config, logic, params));
        this.registerOperator("!", this::notImpl);
        this.registerOperator("!!", this::toBooleanImpl);
        this.registerOperator("or", this::orImpl);
        this.registerOperator("and", this::andImpl);
        this.registerOperator("min", this::minImpl);
        this.registerOperator("max", this::maxImpl);
        this.registerOperator("+", this::plusImpl);
        this.registerOperator("*", this::multiplyImpl);
        this.registerOperator("-", this::minusImpl);
        this.registerOperator("/", this::divideImpl);
        this.registerOperator("%", this::moduloImpl);
        this.registerOperator("map", this::mapImpl);
        this.registerOperator("filter", this::filterImpl);
        this.registerOperator("reduce", this::reduceImpl);
        this.registerOperator("all", (logic, config, params) -> this.arrayTest(logic, config, params, (subConf, stream) -> stream.allMatch(it -> this.isTruthy(logic.apply((JsonValue)subConf, (JsonValue)it)))));
        this.registerOperator("some", (logic, config, params) -> this.arrayTest(logic, config, params, (subConf, stream) -> stream.anyMatch(it -> this.isTruthy(logic.apply((JsonValue)subConf, (JsonValue)it)))));
        this.registerOperator("none", (logic, config, params) -> this.arrayTest(logic, config, params, (subConf, stream) -> stream.noneMatch(it -> this.isTruthy(logic.apply((JsonValue)subConf, (JsonValue)it)))));
        this.registerOperator("merge", (logic, config, params) -> this.mergeImpl(config));
        this.registerOperator("in", this::inImpl);
        this.registerOperator("cat", this::catImpl);
        this.registerOperator("substr", this::substrImpl);
        return this;
    }

    private IllegalArgumentException invalidArgument(Set<String> keys) {
        return new IllegalArgumentException("Invalid argument, multiple keys found: " + keys);
    }

    private IllegalArgumentException missingOperator(String operator) {
        return new IllegalArgumentException("Missing operator '" + operator + "'");
    }

    private JsonValue minImpl(JohnzonJsonLogic logic, JsonValue config, JsonValue params) {
        if (config.getValueType() != JsonValue.ValueType.ARRAY) {
            throw new IllegalArgumentException("min only supports arrays: '" + config + "'");
        }
        return this.provider.createValue(this.mapToDouble(logic, config, params).min().orElse(0.0));
    }

    private JsonValue maxImpl(JohnzonJsonLogic logic, JsonValue config, JsonValue params) {
        if (config.getValueType() != JsonValue.ValueType.ARRAY) {
            throw new IllegalArgumentException("max only supports arrays: '" + config + "'");
        }
        return this.provider.createValue(this.mapToDouble(logic, config, params).max().orElse(0.0));
    }

    private JsonValue plusImpl(JohnzonJsonLogic logic, JsonValue config, JsonValue params) {
        if (config.getValueType() != JsonValue.ValueType.ARRAY) {
            return this.castToNumber(logic.apply(config, params));
        }
        if (config.asJsonArray().isEmpty()) {
            return this.provider.createValue(0);
        }
        return this.provider.createValue(this.mapToDouble(logic, config, params).sum());
    }

    private JsonValue multiplyImpl(JohnzonJsonLogic logic, JsonValue config, JsonValue params) {
        if (config.getValueType() != JsonValue.ValueType.ARRAY) {
            throw new IllegalArgumentException("* only supports arrays: '" + config + "'");
        }
        if (config.asJsonArray().isEmpty()) {
            return this.provider.createValue(0);
        }
        return this.provider.createValue(this.mapToDouble(logic, config, params).reduce(1.0, (a, b) -> a * b));
    }

    private JsonValue minusImpl(JohnzonJsonLogic logic, JsonValue config, JsonValue params) {
        if (config.getValueType() == JsonValue.ValueType.ARRAY) {
            JsonArray array = config.asJsonArray();
            if (array.size() != 2) {
                throw new IllegalArgumentException("- only supports arrays with 2 elements: '" + config + "'");
            }
            return this.provider.createValue(((JsonNumber)JsonNumber.class.cast(logic.apply((JsonValue)array.get(0), params))).doubleValue() - ((JsonNumber)JsonNumber.class.cast(logic.apply((JsonValue)array.get(1), params))).doubleValue());
        }
        JsonValue applied = logic.apply(config, params);
        if (applied.getValueType() == JsonValue.ValueType.NUMBER) {
            return this.provider.createValue(-1.0 * ((JsonNumber)JsonNumber.class.cast(applied)).doubleValue());
        }
        throw new IllegalArgumentException("Unsupported - operation: '" + config + "'");
    }

    private JsonValue divideImpl(JohnzonJsonLogic logic, JsonValue config, JsonValue params) {
        if (config.getValueType() == JsonValue.ValueType.ARRAY) {
            JsonArray array = config.asJsonArray();
            if (array.size() != 2) {
                throw new IllegalArgumentException("/ only supports arrays with 2 elements: '" + config + "'");
            }
            return this.provider.createValue(((JsonNumber)JsonNumber.class.cast(logic.apply((JsonValue)array.get(0), params))).doubleValue() / ((JsonNumber)JsonNumber.class.cast(logic.apply((JsonValue)array.get(1), params))).doubleValue());
        }
        throw new IllegalArgumentException("Unsupported / operation: '" + config + "'");
    }

    private JsonValue moduloImpl(JohnzonJsonLogic logic, JsonValue config, JsonValue params) {
        if (config.getValueType() == JsonValue.ValueType.ARRAY) {
            JsonArray array = config.asJsonArray();
            if (array.size() != 2) {
                throw new IllegalArgumentException("% only supports arrays with 2 elements: '" + config + "'");
            }
            return this.provider.createValue(((JsonNumber)JsonNumber.class.cast(logic.apply((JsonValue)array.get(0), params))).doubleValue() % ((JsonNumber)JsonNumber.class.cast(logic.apply((JsonValue)array.get(1), params))).doubleValue());
        }
        throw new IllegalArgumentException("Unsupported % operation: '" + config + "'");
    }

    private JsonValue mapImpl(JohnzonJsonLogic logic, JsonValue config, JsonValue params) {
        if (config.getValueType() == JsonValue.ValueType.ARRAY) {
            JsonArray array = config.asJsonArray();
            if (array.size() != 2) {
                throw new IllegalArgumentException("map only supports arrays with 2 elements: '" + config + "'");
            }
            JsonValue items = logic.apply((JsonValue)array.get(0), params);
            if (items.getValueType() != JsonValue.ValueType.ARRAY) {
                throw new IllegalArgumentException("Expected '" + array.get(0) + "' to be an array, got " + items.getValueType());
            }
            JsonValue subLogic = (JsonValue)array.get(1);
            return (JsonValue)items.asJsonArray().stream().map(it -> logic.apply(subLogic, (JsonValue)it)).collect(this.toArray());
        }
        throw new IllegalArgumentException("Unsupported map operation: '" + config + "'");
    }

    private JsonValue filterImpl(JohnzonJsonLogic logic, JsonValue config, JsonValue params) {
        if (config.getValueType() == JsonValue.ValueType.ARRAY) {
            JsonArray array = config.asJsonArray();
            if (array.size() != 2) {
                throw new IllegalArgumentException("filter only supports arrays with 2 elements: '" + config + "'");
            }
            JsonValue items = logic.apply((JsonValue)array.get(0), params);
            if (items.getValueType() != JsonValue.ValueType.ARRAY) {
                throw new IllegalArgumentException("Expected '" + array.get(0) + "' to be an array, got " + items.getValueType());
            }
            JsonValue subLogic = (JsonValue)array.get(1);
            return (JsonValue)items.asJsonArray().stream().filter(it -> this.isTruthy(logic.apply(subLogic, (JsonValue)it))).collect(this.toArray());
        }
        throw new IllegalArgumentException("Unsupported filter operation: '" + config + "'");
    }

    private JsonValue mergeImpl(JsonValue config) {
        if (config.getValueType() != JsonValue.ValueType.ARRAY) {
            throw new IllegalArgumentException("merge only support an array as configuration, got '" + config + "'");
        }
        return (JsonValue)config.asJsonArray().stream().flatMap(it -> it.getValueType() == JsonValue.ValueType.ARRAY ? it.asJsonArray().stream() : this.builderFactory.createArrayBuilder().add(it).build().stream()).collect(this.toArray());
    }

    private JsonValue substrImpl(JohnzonJsonLogic logic, JsonValue config, JsonValue params) {
        int end;
        if (config.getValueType() != JsonValue.ValueType.ARRAY || config.asJsonArray().size() < 2) {
            throw new IllegalArgumentException("substr only support an array as configuration, got '" + config + "'");
        }
        JsonArray array = config.asJsonArray();
        JsonValue value = logic.apply((JsonValue)array.get(0), params);
        if (value.getValueType() != JsonValue.ValueType.STRING) {
            throw new IllegalArgumentException("expected a string for substr, got '" + value + "'");
        }
        String valueStr = ((JsonString)JsonString.class.cast(value)).getString();
        JsonValue from = logic.apply((JsonValue)array.get(1), params);
        if (from.getValueType() != JsonValue.ValueType.NUMBER) {
            throw new IllegalArgumentException("expected a number for substr, got '" + from + "'");
        }
        int fromIdx = ((JsonNumber)JsonNumber.class.cast(from)).intValue();
        int start = fromIdx < 0 ? valueStr.length() + fromIdx : fromIdx;
        if (array.size() == 3) {
            JsonValue to = logic.apply((JsonValue)array.get(2), params);
            if (to.getValueType() != JsonValue.ValueType.NUMBER) {
                throw new IllegalArgumentException("expected a number for substr, got '" + to + "'");
            }
            int length = ((JsonNumber)JsonNumber.class.cast(to)).intValue();
            end = length < 0 ? valueStr.length() + length : start + length;
        } else {
            end = valueStr.length();
        }
        return this.provider.createValue(valueStr.substring(start, end));
    }

    private JsonValue catImpl(JohnzonJsonLogic logic, JsonValue config, JsonValue params) {
        if (config.getValueType() != JsonValue.ValueType.ARRAY) {
            throw new IllegalArgumentException("cat only support an array of string elements as configuration, got '" + config + "'");
        }
        return this.provider.createValue(config.asJsonArray().stream().map(it -> logic.apply((JsonValue)it, params)).filter(it -> it.getValueType() == JsonValue.ValueType.STRING).map(it -> ((JsonString)JsonString.class.cast(it)).getString()).collect(Collectors.joining()));
    }

    private JsonValue inImpl(JohnzonJsonLogic logic, JsonValue config, JsonValue params) {
        if (config.getValueType() != JsonValue.ValueType.ARRAY || config.asJsonArray().size() != 2) {
            throw new IllegalArgumentException("in only support an array of 2 elements as configuration, got '" + config + "'");
        }
        JsonArray array = config.asJsonArray();
        JsonValue expected = logic.apply((JsonValue)array.get(0), params);
        JsonValue value = logic.apply((JsonValue)array.get(1), params);
        switch (value.getValueType()) {
            case STRING: {
                return expected.getValueType() == JsonValue.ValueType.STRING && ((JsonString)JsonString.class.cast(value)).getString().contains(((JsonString)JsonString.class.cast(expected)).getString()) ? JsonValue.TRUE : JsonValue.FALSE;
            }
            case ARRAY: {
                return value.getValueType() == JsonValue.ValueType.ARRAY && value.asJsonArray().stream().anyMatch(it -> Objects.equals(it, expected)) ? JsonValue.TRUE : JsonValue.FALSE;
            }
        }
        return JsonValue.FALSE;
    }

    private JsonValue reduceImpl(JohnzonJsonLogic logic, JsonValue config, JsonValue params) {
        if (config.getValueType() == JsonValue.ValueType.ARRAY) {
            JsonArray array = config.asJsonArray();
            if (array.size() < 2 || array.size() > 3) {
                throw new IllegalArgumentException("filter only supports arrays with 2 or 3 elements: '" + config + "'");
            }
            JsonValue items = logic.apply((JsonValue)array.get(0), params);
            if (items.getValueType() != JsonValue.ValueType.ARRAY) {
                throw new IllegalArgumentException("Expected '" + array.get(0) + "' to be an array, got " + items.getValueType());
            }
            JsonValue subLogic = (JsonValue)array.get(1);
            return items.asJsonArray().stream().reduce(array.size() == 3 ? (JsonValue)array.get(2) : JsonValue.NULL, (accumulator, current) -> logic.apply(subLogic, (JsonValue)this.builderFactory.createObjectBuilder().add("accumulator", accumulator).add("current", current).build()));
        }
        throw new IllegalArgumentException("Unsupported reduce operation: '" + config + "'");
    }

    private JsonValue andImpl(JohnzonJsonLogic logic, JsonValue config, JsonValue params) {
        if (config.getValueType() != JsonValue.ValueType.ARRAY) {
            throw new IllegalArgumentException("and only supports arrays: '" + config + "'");
        }
        JsonArray array = config.asJsonArray();
        return array.stream().map(it -> logic.apply((JsonValue)it, params)).filter(this::isFalsy).findFirst().orElseGet(() -> array.isEmpty() ? JsonValue.FALSE : (JsonValue)array.get(array.size() - 1));
    }

    private JsonValue orImpl(JohnzonJsonLogic logic, JsonValue config, JsonValue params) {
        if (config.getValueType() != JsonValue.ValueType.ARRAY) {
            throw new IllegalArgumentException("or only supports arrays: '" + config + "'");
        }
        JsonArray array = config.asJsonArray();
        return array.stream().map(it -> logic.apply((JsonValue)it, params)).filter(this::isTruthy).findFirst().orElseGet(() -> array.isEmpty() ? JsonValue.FALSE : (JsonValue)array.get(array.size() - 1));
    }

    private JsonValue toBooleanImpl(JohnzonJsonLogic logic, JsonValue config, JsonValue params) {
        if (config.getValueType() == JsonValue.ValueType.ARRAY) {
            JsonArray array = config.asJsonArray();
            if (array.size() != 1) {
                throw new IllegalArgumentException("!! takes only one parameter '" + config + "'");
            }
            return this.isTruthy(logic.apply((JsonValue)array.get(0), params)) ? JsonValue.TRUE : JsonValue.FALSE;
        }
        return this.isTruthy(logic.apply(config, params)) ? JsonValue.TRUE : JsonValue.FALSE;
    }

    private JsonValue notImpl(JohnzonJsonLogic logic, JsonValue config, JsonValue params) {
        if (config.getValueType() == JsonValue.ValueType.ARRAY) {
            JsonArray array = config.asJsonArray();
            if (array.size() != 1) {
                throw new IllegalArgumentException("! takes only one parameter '" + config + "'");
            }
            return this.isFalsy(logic.apply((JsonValue)array.get(0), params)) ? JsonValue.TRUE : JsonValue.FALSE;
        }
        return this.isFalsy(logic.apply(config, params)) ? JsonValue.TRUE : JsonValue.FALSE;
    }

    private JsonValue ifImpl(JohnzonJsonLogic logic, JsonValue config, JsonValue params) {
        if (config.getValueType() != JsonValue.ValueType.ARRAY) {
            throw new IllegalArgumentException("if config must be an array");
        }
        JsonArray configArray = config.asJsonArray();
        if (configArray.size() < 2) {
            throw new IllegalArgumentException("if config must be an array >= 2 elements");
        }
        for (int i = 0; i < configArray.size() - 1; i += 2) {
            if (!this.isTruthy(logic.apply((JsonValue)configArray.get(i), params))) continue;
            return logic.apply((JsonValue)configArray.get(i + 1), params);
        }
        if (configArray.size() % 2 == 1) {
            return (JsonValue)configArray.get(configArray.size() - 1);
        }
        return JsonValue.FALSE;
    }

    private JsonValue missingSomeImpl(JohnzonJsonLogic logic, JsonValue config, JsonValue params) {
        if (config.getValueType() != JsonValue.ValueType.ARRAY) {
            throw new IllegalArgumentException("missing_some takes an array as parameter: '" + config + "'");
        }
        JsonArray configArray = config.asJsonArray();
        if (configArray.size() != 2) {
            throw new IllegalArgumentException("missing_some takes an array with a number and a path array as parameter: '" + config + "'");
        }
        JsonArray tested = ((JsonValue)configArray.get(1)).asJsonArray();
        JsonArray missing = tested.stream().filter(it -> this.varImpl(logic.apply((JsonValue)it, params), params) == JsonValue.NULL).collect(this.toArray());
        if (tested.size() - missing.size() < ((JsonNumber)JsonNumber.class.cast(logic.apply((JsonValue)configArray.get(0), params))).intValue()) {
            return missing;
        }
        return JsonValue.EMPTY_JSON_ARRAY;
    }

    private JsonValue missingImpl(JohnzonJsonLogic logic, JsonValue config, JsonValue params) {
        if (config.getValueType() != JsonValue.ValueType.ARRAY) {
            throw new IllegalArgumentException("missing takes an array as parameter: '" + config + "'");
        }
        return (JsonValue)config.asJsonArray().stream().filter(it -> this.varImpl(logic.apply((JsonValue)it, params), params) == JsonValue.NULL).collect(this.toArray());
    }

    private JsonValue arrayTest(JohnzonJsonLogic self, JsonValue config, JsonValue params, BiPredicate<JsonValue, Stream<JsonValue>> tester) {
        if (config.getValueType() == JsonValue.ValueType.ARRAY) {
            JsonArray array = config.asJsonArray();
            if (array.size() != 2) {
                throw new IllegalArgumentException("array test only supports arrays with 2: '" + config + "'");
            }
            JsonValue items = self.apply((JsonValue)array.get(0), params);
            if (items.getValueType() != JsonValue.ValueType.ARRAY) {
                throw new IllegalArgumentException("Expected '" + array.get(0) + "' to be an array, got " + items.getValueType());
            }
            JsonValue subLogic = (JsonValue)array.get(1);
            return tester.test(subLogic, items.asJsonArray().stream()) ? JsonValue.TRUE : JsonValue.FALSE;
        }
        throw new IllegalArgumentException("Unsupported array test operation: '" + config + "'");
    }

    private JsonValue castToNumber(JsonValue value) {
        switch (value.getValueType()) {
            case NUMBER: {
                return value;
            }
            case STRING: {
                return this.provider.createValue(Double.parseDouble(((JsonString)JsonString.class.cast(value)).getString()));
            }
        }
        throw new IllegalArgumentException("Unsupported value to number: '" + value + "'");
    }

    private DoubleStream mapToDouble(JohnzonJsonLogic logic, JsonValue config, JsonValue params) {
        return config.asJsonArray().stream().map(it -> logic.apply((JsonValue)it, params)).filter(it -> it.getValueType() == JsonValue.ValueType.NUMBER).mapToDouble(it -> ((JsonNumber)JsonNumber.class.cast(it)).doubleValue());
    }

    private JsonValue comparison(BiPredicate<JsonValue, JsonValue> comparator, JsonValue config, JohnzonJsonLogic self, JsonValue params) {
        JsonValue second;
        if (config.getValueType() != JsonValue.ValueType.ARRAY) {
            throw new IllegalArgumentException("comparison config must be an array");
        }
        JsonArray values = config.asJsonArray();
        if (values.size() != 2) {
            throw new IllegalArgumentException("comparison requires 2 arguments");
        }
        JsonValue first = self.apply((JsonValue)values.get(0), params);
        return comparator.test(first, second = self.apply((JsonValue)values.get(1), params)) ? JsonValue.TRUE : JsonValue.FALSE;
    }

    private JsonValue numericComparison(BiPredicate<Double, Double> comparator, JsonValue config, JohnzonJsonLogic self, JsonValue params) {
        if (config.getValueType() != JsonValue.ValueType.ARRAY) {
            throw new IllegalArgumentException("numeric comparison config must be an array");
        }
        JsonArray configArray = config.asJsonArray();
        switch (configArray.size()) {
            case 2: {
                JsonValue first = self.apply((JsonValue)configArray.get(0), params);
                JsonValue second = self.apply((JsonValue)configArray.get(1), params);
                if (Stream.of(first, second).anyMatch(it -> it.getValueType() != JsonValue.ValueType.NUMBER)) {
                    throw new IllegalArgumentException("Only numbers can be compared: " + first + " / " + second);
                }
                return comparator.test(((JsonNumber)JsonNumber.class.cast(first)).doubleValue(), ((JsonNumber)JsonNumber.class.cast(second)).doubleValue()) ? JsonValue.TRUE : JsonValue.FALSE;
            }
            case 3: {
                JsonValue first = self.apply((JsonValue)configArray.get(0), params);
                JsonValue second = self.apply((JsonValue)configArray.get(1), params);
                JsonValue third = self.apply((JsonValue)configArray.get(1), params);
                if (Stream.of(first, second, third).anyMatch(it -> it.getValueType() != JsonValue.ValueType.NUMBER)) {
                    throw new IllegalArgumentException("Only numbers can be compared");
                }
                return comparator.test(((JsonNumber)JsonNumber.class.cast(first)).doubleValue(), ((JsonNumber)JsonNumber.class.cast(second)).doubleValue()) && comparator.test(((JsonNumber)JsonNumber.class.cast(second)).doubleValue(), ((JsonNumber)JsonNumber.class.cast(third)).doubleValue()) ? JsonValue.TRUE : JsonValue.FALSE;
            }
        }
        throw new IllegalArgumentException("numeric comparison config must be an array >= 2 elements");
    }

    private JsonValue varImpl(JsonValue config, JsonValue params) {
        switch (config.getValueType()) {
            case ARRAY: {
                JsonArray values = config.asJsonArray();
                if (values.isEmpty()) {
                    throw new IllegalArgumentException("var should have at least one parameter");
                }
                JsonValue accessor = this.apply((JsonValue)values.get(0), params);
                switch (accessor.getValueType()) {
                    case NUMBER: {
                        JsonValue arrayAttribute;
                        int index = ((JsonNumber)JsonNumber.class.cast(accessor)).intValue();
                        JsonArray array = params.asJsonArray();
                        JsonValue jsonValue = arrayAttribute = index >= array.size() ? null : (JsonValue)array.get(index);
                        return arrayAttribute == null ? (values.size() > 1 ? this.apply((JsonValue)values.get(1), params) : JsonValue.NULL) : arrayAttribute;
                    }
                    case STRING: {
                        JsonValue objectAttribute = this.extractValue(params, ((JsonString)JsonString.class.cast(accessor)).getString());
                        return objectAttribute == JsonValue.NULL && values.size() > 1 ? this.apply((JsonValue)values.get(1), params) : objectAttribute;
                    }
                }
                throw new IllegalArgumentException("Unsupported var first paraemter: '" + accessor + "', should be string or number");
            }
            case STRING: {
                return this.extractValue(params, ((JsonString)JsonString.class.cast(config)).getString());
            }
            case NUMBER: {
                int index = ((JsonNumber)JsonNumber.class.cast(config)).intValue();
                JsonArray array = params.asJsonArray();
                JsonValue arrayAttribute = array.size() <= index ? null : (JsonValue)array.get(index);
                return arrayAttribute == null ? JsonValue.NULL : arrayAttribute;
            }
            case OBJECT: {
                return this.varImpl(this.apply(config, params), params);
            }
        }
        throw new IllegalArgumentException("Unsupported configuration for var: '" + config + "'");
    }

    private JsonValue extractValue(JsonValue params, String string) {
        Object objectAttribute;
        if (string.isEmpty()) {
            return params;
        }
        if (string.contains(".")) {
            try {
                objectAttribute = this.toPointer(string).getValue((JsonStructure)JsonStructure.class.cast(params));
            }
            catch (JsonException je) {
                return JsonValue.NULL;
            }
        } else {
            objectAttribute = params.getValueType() == JsonValue.ValueType.OBJECT ? (JsonValue)params.asJsonObject().get((Object)string) : (params.getValueType() == JsonValue.ValueType.ARRAY ? (JsonValue)params.asJsonArray().get(Integer.parseInt(string.trim())) : null);
        }
        return objectAttribute == null ? JsonValue.NULL : objectAttribute;
    }

    private JsonPointer toPointer(String string) {
        if (this.cachePointers) {
            return this.pointers.computeIfAbsent(string, this::doToPointer);
        }
        return this.doToPointer(string);
    }

    private JsonPointer doToPointer(String string) {
        return this.provider.createPointer((!string.startsWith("/") ? "/" : "") + string.replace('.', '/'));
    }

    private Collector<JsonValue, JsonArrayBuilder, JsonArray> toArray() {
        return Collector.of(() -> ((JsonBuilderFactory)this.builderFactory).createArrayBuilder(), JsonArrayBuilder::add, JsonArrayBuilder::addAll, JsonArrayBuilder::build, new Collector.Characteristics[0]);
    }
}

