/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.tcp.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.ServerPanel;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.gui.util.TristateCheckBox;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledTextField;

public class TCPConfigGui
extends AbstractConfigGui {
    private static final long serialVersionUID = 240L;
    private ServerPanel serverPanel;
    private JLabeledTextField classname;
    private JCheckBox reUseConnection;
    private TristateCheckBox setNoDelay;
    private TristateCheckBox closeConnection;
    private JTextField soLinger;
    private JTextField eolByte;
    private JSyntaxTextArea requestData;
    private boolean displayName = true;

    public TCPConfigGui() {
        this(true);
    }

    public TCPConfigGui(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    public String getLabelResource() {
        return "tcp_config_title";
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.classname.setText(element.getPropertyAsString("TCPSampler.classname"));
        this.serverPanel.setServer(element.getPropertyAsString("TCPSampler.server"));
        this.reUseConnection.setSelected(element.getPropertyAsBoolean("TCPSampler.reUseConnection", true));
        this.serverPanel.setPort(element.getPropertyAsString("TCPSampler.port"));
        this.serverPanel.setResponseTimeout(element.getPropertyAsString("TCPSampler.timeout"));
        this.serverPanel.setConnectTimeout(element.getPropertyAsString("TCPSampler.ctimeout"));
        this.setNoDelay.setTristateFromProperty(element, "TCPSampler.nodelay");
        this.requestData.setInitialText(element.getPropertyAsString("TCPSampler.request"));
        this.requestData.setCaretPosition(0);
        this.closeConnection.setTristateFromProperty(element, "TCPSampler.closeConnection");
        this.soLinger.setText(element.getPropertyAsString("TCPSampler.soLinger"));
        this.eolByte.setText(element.getPropertyAsString("TCPSampler.EolByte"));
    }

    public TestElement createTestElement() {
        ConfigTestElement element = new ConfigTestElement();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    public void modifyTestElement(TestElement element) {
        this.configureTestElement(element);
        element.setProperty("TCPSampler.classname", this.classname.getText(), "");
        element.setProperty("TCPSampler.server", this.serverPanel.getServer());
        element.setProperty("TCPSampler.reUseConnection", this.reUseConnection.isSelected());
        element.setProperty("TCPSampler.port", this.serverPanel.getPort());
        this.setNoDelay.setPropertyFromTristate(element, "TCPSampler.nodelay");
        element.setProperty("TCPSampler.timeout", this.serverPanel.getResponseTimeout());
        element.setProperty("TCPSampler.ctimeout", this.serverPanel.getConnectTimeout(), "");
        element.setProperty("TCPSampler.request", this.requestData.getText());
        this.closeConnection.setPropertyFromTristate(element, "TCPSampler.closeConnection");
        element.setProperty("TCPSampler.soLinger", this.soLinger.getText(), "");
        element.setProperty("TCPSampler.EolByte", this.eolByte.getText(), "");
    }

    public void clearGui() {
        super.clearGui();
        this.serverPanel.clear();
        this.classname.setText("");
        this.requestData.setInitialText("");
        this.reUseConnection.setSelected(true);
        this.setNoDelay.setSelected(false);
        this.closeConnection.setSelected(false);
        this.soLinger.setText("");
        this.eolByte.setText("");
    }

    private JPanel createNoDelayPanel() {
        JLabel label = new JLabel(JMeterUtils.getResString((String)"tcp_nodelay"));
        this.setNoDelay = new TristateCheckBox();
        label.setLabelFor((Component)this.setNoDelay);
        JPanel nodelayPanel = new JPanel(new FlowLayout());
        nodelayPanel.add(label);
        nodelayPanel.add((Component)this.setNoDelay);
        return nodelayPanel;
    }

    private JPanel createClosePortPanel() {
        JLabel label = new JLabel(JMeterUtils.getResString((String)"reuseconnection"));
        this.reUseConnection = new JCheckBox("", true);
        this.reUseConnection.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.closeConnection.setEnabled(true);
            } else {
                this.closeConnection.setEnabled(false);
            }
        });
        label.setLabelFor(this.reUseConnection);
        JPanel closePortPanel = new JPanel(new FlowLayout());
        closePortPanel.add(label);
        closePortPanel.add(this.reUseConnection);
        return closePortPanel;
    }

    private JPanel createCloseConnectionPanel() {
        JLabel label = new JLabel(JMeterUtils.getResString((String)"closeconnection"));
        this.closeConnection = new TristateCheckBox("", false);
        label.setLabelFor((Component)this.closeConnection);
        JPanel closeConnectionPanel = new JPanel(new FlowLayout());
        closeConnectionPanel.add(label);
        closeConnectionPanel.add((Component)this.closeConnection);
        return closeConnectionPanel;
    }

    private JPanel createSoLingerOption() {
        JLabel label = new JLabel(JMeterUtils.getResString((String)"solinger"));
        this.soLinger = new JTextField(5);
        this.soLinger.setMaximumSize(new Dimension(this.soLinger.getPreferredSize()));
        label.setLabelFor(this.soLinger);
        JPanel soLingerPanel = new JPanel(new FlowLayout());
        soLingerPanel.add(label);
        soLingerPanel.add(this.soLinger);
        return soLingerPanel;
    }

    private JPanel createEolBytePanel() {
        JLabel label = new JLabel(JMeterUtils.getResString((String)"eolbyte"));
        this.eolByte = new JTextField(3);
        this.eolByte.setMaximumSize(new Dimension(this.eolByte.getPreferredSize()));
        label.setLabelFor(this.eolByte);
        JPanel eolBytePanel = new JPanel(new FlowLayout());
        eolBytePanel.add(label);
        eolBytePanel.add(this.eolByte);
        return eolBytePanel;
    }

    private JPanel createRequestPanel() {
        JLabel reqLabel = new JLabel(JMeterUtils.getResString((String)"tcp_request_data"));
        this.requestData = JSyntaxTextArea.getInstance((int)15, (int)80);
        this.requestData.setLanguage("text");
        reqLabel.setLabelFor((Component)this.requestData);
        JPanel reqDataPanel = new JPanel(new BorderLayout(5, 0));
        reqDataPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder()));
        reqDataPanel.add((Component)reqLabel, "West");
        reqDataPanel.add((Component)JTextScrollPane.getInstance((JSyntaxTextArea)this.requestData), "Center");
        return reqDataPanel;
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.serverPanel = new ServerPanel();
        if (this.displayName) {
            this.setBorder(this.makeBorder());
            this.add(this.makeTitlePanel(), "North");
        }
        VerticalPanel mainPanel = new VerticalPanel();
        this.classname = new JLabeledTextField(JMeterUtils.getResString((String)"tcp_classname"));
        mainPanel.add((Component)this.classname);
        mainPanel.add((Component)this.serverPanel);
        HorizontalPanel optionsPanel = new HorizontalPanel();
        optionsPanel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder()));
        optionsPanel.add((Component)this.createClosePortPanel());
        optionsPanel.add((Component)this.createCloseConnectionPanel());
        optionsPanel.add((Component)this.createNoDelayPanel());
        optionsPanel.add((Component)this.createSoLingerOption());
        optionsPanel.add((Component)this.createEolBytePanel());
        mainPanel.add((Component)optionsPanel);
        mainPanel.add((Component)this.createRequestPanel());
        this.add((Component)mainPanel, "Center");
    }
}

