/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.system;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.exec.SystemCommand;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class SystemSampler
extends AbstractSampler {
    private static final int POLL_INTERVAL = JMeterUtils.getPropDefault((String)"os_sampler.poll_for_timeout", (int)100);
    private static final long serialVersionUID = 1L;
    public static final String COMMAND = "SystemSampler.command";
    public static final String DIRECTORY = "SystemSampler.directory";
    public static final String ARGUMENTS = "SystemSampler.arguments";
    public static final String ENVIRONMENT = "SystemSampler.environment";
    public static final String CHECK_RETURN_CODE = "SystemSampler.checkReturnCode";
    public static final String EXPECTED_RETURN_CODE = "SystemSampler.expectedReturnCode";
    private static final String STDOUT = "SystemSampler.stdout";
    private static final String STDERR = "SystemSampler.stderr";
    private static final String STDIN = "SystemSampler.stdin";
    private static final String TIMEOUT = "SystemSampler.timeout";
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final Set<String> APPLIABLE_CONFIG_CLASSES = new HashSet<String>(Arrays.asList("org.apache.jmeter.config.gui.SimpleConfigGui"));
    public static final int DEFAULT_RETURN_CODE = 0;

    public SampleResult sample(Entry entry) {
        SampleResult results = new SampleResult();
        results.setDataType("text");
        results.setSampleLabel(this.getName());
        String command = this.getCommand();
        Arguments args = this.getArguments();
        Arguments environment = this.getEnvironmentVariables();
        boolean checkReturnCode = this.getCheckReturnCode();
        int expectedReturnCode = this.getExpectedReturnCode();
        ArrayList<String> cmds = new ArrayList<String>(args.getArgumentCount() + 1);
        StringBuilder cmdLine = new StringBuilder(null == command ? "" : command);
        cmds.add(command);
        for (int i = 0; i < args.getArgumentCount(); ++i) {
            Argument arg = args.getArgument(i);
            cmds.add(arg.getPropertyAsString("Argument.value"));
            cmdLine.append(" ");
            cmdLine.append((String)cmds.get(i + 1));
        }
        HashMap<String, String> env = new HashMap<String, String>();
        for (int i = 0; i < environment.getArgumentCount(); ++i) {
            Argument arg = environment.getArgument(i);
            env.put(arg.getName(), arg.getPropertyAsString("Argument.value"));
        }
        File directory = null;
        if (StringUtils.isEmpty((CharSequence)this.getDirectory())) {
            directory = new File(FileServer.getDefaultBase());
            if (log.isDebugEnabled()) {
                log.debug("Using default directory:" + directory.getAbsolutePath());
            }
        } else {
            directory = new File(this.getDirectory());
            if (log.isDebugEnabled()) {
                log.debug("Using configured directory:" + directory.getAbsolutePath());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Will run : " + cmdLine + " using working directory:" + directory.getAbsolutePath() + " with environment: " + env);
        }
        results.setSamplerData("Working Directory: " + directory.getAbsolutePath() + "\nEnvironment: " + env + "\nExecuting: " + cmdLine.toString());
        SystemCommand nativeCommand = null;
        try {
            nativeCommand = new SystemCommand(directory, this.getTimeout(), POLL_INTERVAL, env, this.getStdin(), this.getStdout(), this.getStderr());
            results.sampleStart();
            int returnCode = nativeCommand.run(cmds);
            results.sampleEnd();
            results.setResponseCode(Integer.toString(returnCode));
            if (log.isDebugEnabled()) {
                log.debug("Ran : " + cmdLine + " using working directory: " + directory.getAbsolutePath() + " with execution environment: " + nativeCommand.getExecutionEnvironment() + " => " + returnCode);
            }
            if (checkReturnCode && returnCode != expectedReturnCode) {
                results.setSuccessful(false);
                results.setResponseMessage("Unexpected return code.  Expected [" + expectedReturnCode + "]. Actual [" + returnCode + "].");
            } else {
                results.setSuccessful(true);
                results.setResponseMessage("OK");
            }
        }
        catch (IOException ioe) {
            results.sampleEnd();
            results.setSuccessful(false);
            results.setResponseMessage("Exception occurred whilst executing system call: " + ioe);
        }
        catch (InterruptedException ie) {
            results.sampleEnd();
            results.setSuccessful(false);
            results.setResponseMessage("System Sampler interrupted whilst executing system call: " + ie);
        }
        if (nativeCommand != null) {
            results.setResponseData(nativeCommand.getOutResult().getBytes());
        }
        return results;
    }

    public boolean applies(ConfigTestElement configElement) {
        String guiClass = configElement.getProperty("TestElement.gui_class").getStringValue();
        return APPLIABLE_CONFIG_CLASSES.contains(guiClass);
    }

    public String getDirectory() {
        return this.getPropertyAsString(DIRECTORY, FileServer.getDefaultBase());
    }

    public void setDirectory(String directory) {
        this.setProperty(DIRECTORY, directory, FileServer.getDefaultBase());
    }

    public void setCommand(String command) {
        this.setProperty(COMMAND, command);
    }

    public String getCommand() {
        return this.getPropertyAsString(COMMAND);
    }

    public void setArguments(Arguments args) {
        this.setProperty((JMeterProperty)new TestElementProperty(ARGUMENTS, (TestElement)args));
    }

    public Arguments getArguments() {
        return (Arguments)this.getProperty(ARGUMENTS).getObjectValue();
    }

    public void setCheckReturnCode(boolean checkit) {
        this.setProperty(CHECK_RETURN_CODE, checkit);
    }

    public boolean getCheckReturnCode() {
        return this.getPropertyAsBoolean(CHECK_RETURN_CODE);
    }

    public void setExpectedReturnCode(int code) {
        this.setProperty(EXPECTED_RETURN_CODE, Integer.toString(code));
    }

    public int getExpectedReturnCode() {
        return this.getPropertyAsInt(EXPECTED_RETURN_CODE);
    }

    public void setEnvironmentVariables(Arguments arguments) {
        this.setProperty((JMeterProperty)new TestElementProperty(ENVIRONMENT, (TestElement)arguments));
    }

    public Arguments getEnvironmentVariables() {
        return (Arguments)this.getProperty(ENVIRONMENT).getObjectValue();
    }

    public String getStdout() {
        return this.getPropertyAsString(STDOUT, "");
    }

    public void setStdout(String filename) {
        this.setProperty(STDOUT, filename, "");
    }

    public String getStderr() {
        return this.getPropertyAsString(STDERR, "");
    }

    public void setStderr(String filename) {
        this.setProperty(STDERR, filename, "");
    }

    public String getStdin() {
        return this.getPropertyAsString(STDIN, "");
    }

    public void setStdin(String filename) {
        this.setProperty(STDIN, filename, "");
    }

    public long getTimeout() {
        return this.getPropertyAsLong(TIMEOUT, 0L);
    }

    public void setTimout(long timeoutMs) {
        this.setProperty(TIMEOUT, timeoutMs, 0L);
    }
}

