/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.smtp.sampler.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import org.apache.jmeter.protocol.smtp.sampler.SmtpSampler;
import org.apache.jmeter.protocol.smtp.sampler.gui.SecuritySettingsPanel;
import org.apache.jmeter.protocol.smtp.sampler.gui.SmtpPanel;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;

public class SmtpSamplerGui
extends AbstractSamplerGui {
    private static final long serialVersionUID = 1L;
    private SmtpPanel smtpPanel;

    public SmtpSamplerGui() {
        this.init();
    }

    public String getLabelResource() {
        return "smtp_sampler_title";
    }

    public void configure(TestElement element) {
        if (this.smtpPanel == null) {
            this.smtpPanel = new SmtpPanel();
        }
        this.smtpPanel.setServer(element.getPropertyAsString("SMTPSampler.server"));
        this.smtpPanel.setPort(element.getPropertyAsString("SMTPSampler.serverPort"));
        this.smtpPanel.setMailFrom(element.getPropertyAsString("SMTPSampler.mailFrom"));
        this.smtpPanel.setMailReplyTo(element.getPropertyAsString("SMTPSampler.replyTo"));
        this.smtpPanel.setReceiverTo(element.getPropertyAsString("SMTPSampler.receiverTo"));
        this.smtpPanel.setReceiverCC(element.getPropertyAsString("SMTPSampler.receiverCC"));
        this.smtpPanel.setReceiverBCC(element.getPropertyAsString("SMTPSampler.receiverBCC"));
        this.smtpPanel.setBody(element.getPropertyAsString("SMTPSampler.message"));
        this.smtpPanel.setPlainBody(element.getPropertyAsBoolean("SMTPSampler.plainBody"));
        this.smtpPanel.setSubject(element.getPropertyAsString("SMTPSampler.subject"));
        this.smtpPanel.setSuppressSubject(element.getPropertyAsBoolean("SMTPSampler.suppressSubject"));
        this.smtpPanel.setIncludeTimestamp(element.getPropertyAsBoolean("SMTPSampler.include_timestamp"));
        JMeterProperty headers = element.getProperty("SMTPSampler.headerFields");
        if (headers instanceof CollectionProperty) {
            this.smtpPanel.setHeaderFields((CollectionProperty)headers);
        } else {
            this.smtpPanel.setHeaderFields(new CollectionProperty());
        }
        this.smtpPanel.setAttachments(element.getPropertyAsString("SMTPSampler.attachFile"));
        this.smtpPanel.setUseEmlMessage(element.getPropertyAsBoolean("SMTPSampler.use_eml"));
        this.smtpPanel.setEmlMessage(element.getPropertyAsString("SMTPSampler.emlMessageToSend"));
        SecuritySettingsPanel secPanel = this.smtpPanel.getSecuritySettingsPanel();
        secPanel.configure(element);
        this.smtpPanel.setUseAuth(element.getPropertyAsBoolean("SMTPSampler.useAuth"));
        this.smtpPanel.setUsername(element.getPropertyAsString("SMTPSampler.username"));
        this.smtpPanel.setPassword(element.getPropertyAsString("SMTPSampler.password"));
        this.smtpPanel.setMessageSizeStatistic(element.getPropertyAsBoolean("SMTPSampler.messageSizeStatistics"));
        this.smtpPanel.setEnableDebug(element.getPropertyAsBoolean("SMTPSampler.enableDebug"));
        super.configure(element);
    }

    public TestElement createTestElement() {
        SmtpSampler sampler = new SmtpSampler();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement te) {
        te.clear();
        super.configureTestElement(te);
        te.setProperty("SMTPSampler.server", this.smtpPanel.getServer());
        te.setProperty("SMTPSampler.serverPort", this.smtpPanel.getPort());
        te.setProperty("SMTPSampler.mailFrom", this.smtpPanel.getMailFrom());
        te.setProperty("SMTPSampler.replyTo", this.smtpPanel.getMailReplyTo());
        te.setProperty("SMTPSampler.receiverTo", this.smtpPanel.getReceiverTo());
        te.setProperty("SMTPSampler.receiverCC", this.smtpPanel.getReceiverCC());
        te.setProperty("SMTPSampler.receiverBCC", this.smtpPanel.getReceiverBCC());
        te.setProperty("SMTPSampler.subject", this.smtpPanel.getSubject());
        te.setProperty("SMTPSampler.suppressSubject", Boolean.toString(this.smtpPanel.isSuppressSubject()));
        te.setProperty("SMTPSampler.include_timestamp", Boolean.toString(this.smtpPanel.isIncludeTimestamp()));
        te.setProperty("SMTPSampler.message", this.smtpPanel.getBody());
        te.setProperty("SMTPSampler.plainBody", Boolean.toString(this.smtpPanel.isPlainBody()));
        te.setProperty("SMTPSampler.attachFile", this.smtpPanel.getAttachments());
        SecuritySettingsPanel secPanel = this.smtpPanel.getSecuritySettingsPanel();
        secPanel.modifyTestElement(te);
        te.setProperty("SMTPSampler.use_eml", this.smtpPanel.isUseEmlMessage());
        te.setProperty("SMTPSampler.emlMessageToSend", this.smtpPanel.getEmlMessage());
        te.setProperty("SMTPSampler.useAuth", Boolean.toString(this.smtpPanel.isUseAuth()));
        te.setProperty("SMTPSampler.password", this.smtpPanel.getPassword());
        te.setProperty("SMTPSampler.username", this.smtpPanel.getUsername());
        te.setProperty("SMTPSampler.messageSizeStatistics", Boolean.toString(this.smtpPanel.isMessageSizeStatistics()));
        te.setProperty("SMTPSampler.enableDebug", Boolean.toString(this.smtpPanel.isEnableDebug()));
        te.setProperty((JMeterProperty)this.smtpPanel.getHeaderFields());
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        this.add(this.makeDataPanel(), "Center");
    }

    public void clearGui() {
        super.clearGui();
        if (this.smtpPanel != null) {
            this.smtpPanel.clear();
        }
    }

    private Component makeDataPanel() {
        if (this.smtpPanel == null) {
            this.smtpPanel = new SmtpPanel();
        }
        return this.smtpPanel;
    }
}

