/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler.render;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jmeter.protocol.jms.sampler.render.BinaryMessageRenderer;
import org.apache.jmeter.protocol.jms.sampler.render.MapMessageRenderer;
import org.apache.jmeter.protocol.jms.sampler.render.MessageRenderer;
import org.apache.jmeter.protocol.jms.sampler.render.ObjectMessageRenderer;
import org.apache.jmeter.protocol.jms.sampler.render.TextMessageRenderer;

enum RendererFactory {
    INSTANCE;

    private TextMessageRenderer text = new TextMessageRenderer();
    private BinaryMessageRenderer binary = new BinaryMessageRenderer(this.text);
    private ObjectMessageRenderer object = new ObjectMessageRenderer(this.text);
    private MapMessageRenderer map = new MapMessageRenderer(this.text);
    private Map<Class<?>, MessageRenderer<?>> renderers;

    private RendererFactory() {
        LinkedHashMap<Class, MessageRenderer<String>> writable = new LinkedHashMap<Class, MessageRenderer<String>>();
        writable.put(String.class, this.text);
        writable.put(byte[].class, this.binary);
        writable.put(Serializable.class, this.object);
        writable.put(Map.class, this.map);
        this.renderers = Collections.unmodifiableMap(writable);
    }

    public static RendererFactory getInstance() {
        return INSTANCE;
    }

    public TextMessageRenderer getText() {
        return this.text;
    }

    public BinaryMessageRenderer getBinary() {
        return this.binary;
    }

    public ObjectMessageRenderer getObject() {
        return this.object;
    }

    public MapMessageRenderer getMap() {
        return this.map;
    }

    public <T> MessageRenderer<T> getInstance(Class<T> type) {
        return this.renderers.get(type);
    }
}

