/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import javax.jms.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageAdmin {
    private static final MessageAdmin SINGLETON = new MessageAdmin();
    private final Map<String, PlaceHolder> table = new ConcurrentHashMap<String, PlaceHolder>();
    private static final Logger log = LoggerFactory.getLogger(MessageAdmin.class);

    private MessageAdmin() {
    }

    public static MessageAdmin getAdmin() {
        return SINGLETON;
    }

    public void putRequest(String id, Message request, CountDownLatch latch) {
        log.debug("REQ_ID [{}]", (Object)id);
        this.table.put(id, new PlaceHolder(request, latch));
    }

    public void putReply(String id, Message reply) {
        PlaceHolder holder = this.table.get(id);
        log.debug("RPL_ID [{}] for holder {}", (Object)id, (Object)holder);
        if (holder != null) {
            holder.setReply(reply);
            CountDownLatch latch = holder.getLatch();
            log.debug("{} releasing latch : {}", (Object)Thread.currentThread().getName(), (Object)latch);
            latch.countDown();
            log.debug("{} released latch : {}", (Object)Thread.currentThread().getName(), (Object)latch);
        } else if (log.isDebugEnabled()) {
            log.debug("Failed to match reply: {}", (Object)reply);
        }
    }

    public Message get(String id) {
        PlaceHolder holder = this.table.remove(id);
        log.debug("GET_ID [{}] for {}", (Object)id, (Object)holder);
        if (holder == null || !holder.hasReply()) {
            log.debug("Message with {} not found.", (Object)id);
        }
        return holder == null ? null : (Message)holder.getReply();
    }

    private static final class PlaceHolder {
        private final CountDownLatch latch;
        private final Object request;
        private Object reply;

        PlaceHolder(Object original, CountDownLatch latch) {
            this.request = original;
            this.latch = latch;
        }

        void setReply(Object reply) {
            this.reply = reply;
        }

        public Object getReply() {
            return this.reply;
        }

        public Object getRequest() {
            return this.request;
        }

        boolean hasReply() {
            return this.reply != null;
        }

        public String toString() {
            return "request=" + this.request + ", reply=" + this.reply;
        }

        public CountDownLatch getLatch() {
            return this.latch;
        }
    }
}

