/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.client;

import java.io.Closeable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.jmeter.protocol.jms.Utils;
import org.apache.jmeter.protocol.jms.client.InitialContextFactory;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ReceiveSubscriber
implements Closeable,
MessageListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final Connection connection;
    private final Session session;
    private final MessageConsumer subscriber;
    private final LinkedBlockingQueue<Message> queue;
    private boolean connectionStarted;

    public ReceiveSubscriber(boolean useProps, String initialContextFactory, String providerUrl, String connfactory, String destinationName, String durableSubscriptionId, String clientId, String jmsSelector, boolean useAuth, String securityPrincipal, String securityCredentials) throws NamingException, JMSException {
        this(0, useProps, initialContextFactory, providerUrl, connfactory, destinationName, durableSubscriptionId, clientId, jmsSelector, useAuth, securityPrincipal, securityCredentials, false);
    }

    public ReceiveSubscriber(int queueSize, boolean useProps, String initialContextFactory, String providerUrl, String connfactory, String destinationName, String durableSubscriptionId, String clientId, String jmsSelector, boolean useAuth, String securityPrincipal, String securityCredentials) throws NamingException, JMSException {
        this(queueSize, useProps, initialContextFactory, providerUrl, connfactory, destinationName, durableSubscriptionId, clientId, jmsSelector, useAuth, securityPrincipal, securityCredentials, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReceiveSubscriber(int queueSize, boolean useProps, String initialContextFactory, String providerUrl, String connfactory, String destinationName, String durableSubscriptionId, String clientId, String jmsSelector, boolean useAuth, String securityPrincipal, String securityCredentials, boolean useMessageListener) throws NamingException, JMSException {
        boolean initSuccess = false;
        try {
            Context ctx = InitialContextFactory.getContext(useProps, initialContextFactory, providerUrl, useAuth, securityPrincipal, securityCredentials);
            this.connection = Utils.getConnection(ctx, connfactory);
            if (!this.isEmpty(clientId)) {
                this.connection.setClientID(clientId);
            }
            this.session = this.connection.createSession(false, 1);
            Destination dest = Utils.lookupDestination(ctx, destinationName);
            this.subscriber = this.createSubscriber(this.session, dest, durableSubscriptionId, jmsSelector);
            if (useMessageListener) {
                this.queue = queueSize <= 0 ? new LinkedBlockingQueue() : new LinkedBlockingQueue(queueSize);
                this.subscriber.setMessageListener((MessageListener)this);
            } else {
                this.queue = null;
            }
            log.debug("<init> complete");
            initSuccess = true;
        }
        finally {
            if (!initSuccess) {
                this.close();
            }
        }
    }

    private MessageConsumer createSubscriber(Session session, Destination destination, String durableSubscriptionId, String jmsSelector) throws JMSException {
        if (this.isEmpty(durableSubscriptionId)) {
            if (this.isEmpty(jmsSelector)) {
                return session.createConsumer(destination);
            }
            return session.createConsumer(destination, jmsSelector);
        }
        if (this.isEmpty(jmsSelector)) {
            return session.createDurableSubscriber((Topic)destination, durableSubscriptionId);
        }
        return session.createDurableSubscriber((Topic)destination, durableSubscriptionId, jmsSelector, false);
    }

    public void start() throws JMSException {
        log.debug("start()");
        this.connection.start();
        this.connectionStarted = true;
    }

    public void stop() throws JMSException {
        log.debug("stop()");
        this.connection.stop();
        this.connectionStarted = false;
    }

    public Message getMessage(long timeout) throws JMSException {
        Message message = null;
        if (this.queue != null) {
            try {
                message = timeout < 10L ? this.queue.poll() : this.queue.poll(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return message;
        }
        message = timeout < 10L ? this.subscriber.receiveNoWait() : this.subscriber.receive(timeout);
        return message;
    }

    @Override
    public void close() {
        log.debug("close()");
        try {
            if (this.connection != null && this.connectionStarted) {
                this.connection.stop();
                this.connectionStarted = false;
            }
        }
        catch (JMSException e) {
            log.warn("Stopping connection throws exception, message:" + e.getMessage());
        }
        Utils.close(this.subscriber, log);
        Utils.close(this.session, log);
        Utils.close(this.connection, log);
    }

    public void onMessage(Message message) {
        if (!this.queue.offer(message)) {
            log.warn("Could not add message to queue");
        }
    }

    private boolean isEmpty(String s1) {
        return s1 == null || s1.trim().equals("");
    }
}

