/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.util;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apiguardian.api.API;

public class ConversionUtils {
    private static final String CHARSET_EQ = "charset=";
    private static final int CHARSET_EQ_LEN = "charset=".length();
    private static final String SLASHDOTDOT = "/..";
    private static final String DOTDOT = "..";
    private static final String SLASH = "/";
    private static final String COLONSLASHSLASH = "://";
    private static final Pattern MAKE_RELATIVE_PATTERN = Pattern.compile("^/((?:\\.\\./)+)");

    public static String getEncodingFromContentType(String contentType) {
        int charSetStartPos;
        String charSet = null;
        if (contentType != null && (charSetStartPos = contentType.toLowerCase(Locale.ENGLISH).indexOf(CHARSET_EQ)) >= 0 && (charSet = contentType.substring(charSetStartPos + CHARSET_EQ_LEN)) != null) {
            charSet = StringUtils.replaceChars((String)charSet, (String)"'\"", null);
            if ((charSet = charSet.trim()).length() > 0) {
                int semi = charSet.indexOf(59);
                if (semi == 0) {
                    return null;
                }
                if (semi != -1) {
                    charSet = charSet.substring(0, semi);
                }
                if (!Charset.isSupported(charSet)) {
                    return null;
                }
                return charSet;
            }
            return null;
        }
        return charSet;
    }

    @API(status=API.Status.MAINTAINED, since="5.6")
    public static String percentEncode(String value) {
        try {
            return new URI(null, null, value, null).toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Can't encode value " + value, e);
        }
    }

    public static URL makeRelativeURL(URL baseURL, String location) throws MalformedURLException {
        String prefix;
        URL initial = new URL(baseURL, location);
        if (!location.startsWith("../")) {
            return initial;
        }
        String path = initial.getPath();
        Matcher m = MAKE_RELATIVE_PATTERN.matcher(path);
        if (m.lookingAt() && location.startsWith(prefix = m.group(1))) {
            return new URL(baseURL, location.substring(prefix.length()));
        }
        return initial;
    }

    public static String escapeIllegalURLCharacters(String url) throws Exception {
        String decodeUrl = URLDecoder.decode(url, StandardCharsets.UTF_8.name());
        URL urlString = new URL(decodeUrl);
        URI uri = new URI(urlString.getProtocol(), urlString.getUserInfo(), urlString.getHost(), urlString.getPort(), urlString.getPath(), urlString.getQuery(), urlString.getRef());
        return uri.toString();
    }

    public static URI sanitizeUrl(URL url) throws URISyntaxException {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            return new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        }
    }

    public static String removeSlashDotDot(String url) {
        if (url == null) {
            return url;
        }
        if ((url = url.trim()).length() < 4 || !url.contains(SLASHDOTDOT)) {
            return url;
        }
        int dotSlashSlashIndex = url.indexOf(COLONSLASHSLASH);
        int pathStartIndex = dotSlashSlashIndex >= 0 ? url.indexOf(SLASH, dotSlashSlashIndex + COLONSLASHSLASH.length()) : 0;
        int pathEndIndex = url.length();
        int questionMarkIdx = url.indexOf(63);
        if (questionMarkIdx > 0) {
            pathEndIndex = questionMarkIdx;
        } else {
            int anchorIdx = url.indexOf(35);
            if (anchorIdx > 0) {
                pathEndIndex = anchorIdx;
            }
        }
        String currentPath = url.substring(pathStartIndex, pathEndIndex);
        boolean startsWithSlash = currentPath.startsWith(SLASH);
        boolean endsWithSlash = currentPath.endsWith(SLASH);
        StringTokenizer st = new StringTokenizer(currentPath, SLASH);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        for (int i = 0; i < tokens.size(); ++i) {
            String thisToken;
            if (i >= tokens.size() - 1 || (thisToken = (String)tokens.get(i)).length() <= 0 || thisToken.equals(DOTDOT) || !((String)tokens.get(i + 1)).equals(DOTDOT)) continue;
            tokens.remove(i);
            tokens.remove(i);
            if ((i -= 2) >= -1) continue;
            i = -1;
        }
        StringBuilder newPath = new StringBuilder();
        if (startsWithSlash) {
            newPath.append(SLASH);
        }
        for (int i = 0; i < tokens.size(); ++i) {
            boolean appendSlash;
            newPath.append((String)tokens.get(i));
            boolean bl = appendSlash = i < tokens.size() - 1 ? true : endsWithSlash;
            if (!appendSlash) continue;
            newPath.append(SLASH);
        }
        StringBuilder s = new StringBuilder(url);
        s.replace(pathStartIndex, pathEndIndex, newPath.toString());
        return s.toString();
    }
}

