/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler.hc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class LaxGZIPInputStream
extends GZIPInputStream {
    private final boolean relax;

    public LaxGZIPInputStream(InputStream wrapped, boolean relax) throws IOException {
        super(wrapped);
        this.relax = relax;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return super.read(b, off, len);
        }
        catch (EOFException ex) {
            return LaxGZIPInputStream.handleRelaxMode(ex, this.relax);
        }
    }

    @Override
    public int read() throws IOException {
        try {
            return super.read();
        }
        catch (EOFException ex) {
            return LaxGZIPInputStream.handleRelaxMode(ex, this.relax);
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        try {
            return super.read(b);
        }
        catch (EOFException ex) {
            return LaxGZIPInputStream.handleRelaxMode(ex, this.relax);
        }
    }

    private static int handleRelaxMode(EOFException ex, boolean relaxMode) throws EOFException {
        if (relaxMode) {
            return -1;
        }
        throw ex;
    }
}

