/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.http.config.GraphQLRequestParams;
import org.apache.jmeter.protocol.http.util.EncoderCache;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphQLRequestParamUtils {
    private static final String VARIABLES_FIELD = "variables";
    private static final String OPERATION_NAME_FIELD = "operationName";
    private static final String QUERY_FIELD = "query";
    private static Logger log = LoggerFactory.getLogger(GraphQLRequestParamUtils.class);
    private static final Pattern WHITESPACES_PATTERN = Pattern.compile("\\p{Space}+");

    private GraphQLRequestParamUtils() {
    }

    public static boolean isGraphQLContentType(String contentType) {
        if (StringUtils.isEmpty((CharSequence)contentType)) {
            return false;
        }
        ContentType type = ContentType.parse((String)contentType);
        return ContentType.APPLICATION_JSON.getMimeType().equals(type.getMimeType());
    }

    public static String toPostBodyString(GraphQLRequestParams params) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode postBodyJson = mapper.createObjectNode();
        postBodyJson.set(OPERATION_NAME_FIELD, (JsonNode)JsonNodeFactory.instance.textNode(StringUtils.trimToNull((String)params.getOperationName())));
        if (StringUtils.isNotBlank((CharSequence)params.getVariables())) {
            try {
                ObjectNode variablesJson = (ObjectNode)mapper.readValue(params.getVariables(), ObjectNode.class);
                postBodyJson.set(VARIABLES_FIELD, (JsonNode)variablesJson);
            }
            catch (JsonProcessingException e) {
                log.error("Ignoring the GraphQL query variables content due to the syntax error: {}", (Object)e.getLocalizedMessage());
            }
        }
        postBodyJson.set(QUERY_FIELD, (JsonNode)JsonNodeFactory.instance.textNode(StringUtils.trim((String)params.getQuery())));
        try {
            return mapper.writeValueAsString((Object)postBodyJson);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Cannot serialize JSON for POST body string", e);
        }
    }

    public static String queryToGetParamValue(String query) {
        return RegExUtils.replaceAll((String)StringUtils.trim((String)query), (Pattern)WHITESPACES_PATTERN, (String)" ");
    }

    public static String variablesToGetParamValue(String variables) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            ObjectNode variablesJson = (ObjectNode)mapper.readValue(variables, ObjectNode.class);
            return mapper.writeValueAsString((Object)variablesJson);
        }
        catch (JsonProcessingException e) {
            log.error("Ignoring the GraphQL query variables content due to the syntax error: {}", (Object)e.getLocalizedMessage());
            return null;
        }
    }

    public static GraphQLRequestParams toGraphQLRequestParams(byte[] postData, String contentEncoding) throws JsonProcessingException, UnsupportedEncodingException {
        JsonNodeType nodeType;
        JsonNode variablesNode;
        JsonNode operationNameNode;
        ObjectNode data;
        String encoding = StringUtils.isNotEmpty((CharSequence)contentEncoding) ? contentEncoding : EncoderCache.URL_ARGUMENT_ENCODING;
        ObjectMapper mapper = new ObjectMapper();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(postData), encoding);){
            data = (ObjectNode)mapper.readValue((Reader)reader, ObjectNode.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid json data: " + e.getLocalizedMessage());
        }
        String operationName = null;
        String variables = null;
        JsonNode jsonNode = operationNameNode = data.has(OPERATION_NAME_FIELD) ? data.get(OPERATION_NAME_FIELD) : null;
        if (operationNameNode != null) {
            operationName = GraphQLRequestParamUtils.getJsonNodeTextContent(operationNameNode, true);
        }
        if (!data.has(QUERY_FIELD)) {
            throw new IllegalArgumentException("Not a valid GraphQL query.");
        }
        JsonNode queryNode = data.get(QUERY_FIELD);
        String query = GraphQLRequestParamUtils.getJsonNodeTextContent(queryNode, false);
        String trimmedQuery = StringUtils.trim((String)query);
        if (!StringUtils.startsWith((CharSequence)trimmedQuery, (CharSequence)QUERY_FIELD) && !StringUtils.startsWith((CharSequence)trimmedQuery, (CharSequence)"mutation")) {
            throw new IllegalArgumentException("Not a valid GraphQL query.");
        }
        JsonNode jsonNode2 = variablesNode = data.has(VARIABLES_FIELD) ? data.get(VARIABLES_FIELD) : null;
        if (variablesNode != null && (nodeType = variablesNode.getNodeType()) != JsonNodeType.NULL) {
            if (nodeType == JsonNodeType.OBJECT) {
                variables = mapper.writeValueAsString((Object)variablesNode);
            } else {
                throw new IllegalArgumentException("Not a valid object node for GraphQL variables.");
            }
        }
        return new GraphQLRequestParams(operationName, query, variables);
    }

    public static GraphQLRequestParams toGraphQLRequestParams(Arguments arguments, String contentEncoding) throws UnsupportedEncodingException {
        String encoding = (String)StringUtils.defaultIfEmpty((CharSequence)contentEncoding, (CharSequence)EncoderCache.URL_ARGUMENT_ENCODING);
        String operationName = null;
        String query = null;
        String variables = null;
        for (JMeterProperty prop : arguments) {
            Argument arg = (Argument)prop.getObjectValue();
            if (!(arg instanceof HTTPArgument)) continue;
            String name = arg.getName();
            String metadata = arg.getMetaData();
            String value = StringUtils.trimToNull((String)arg.getValue());
            if (!"=".equals(metadata) || value == null) continue;
            boolean alwaysEncoded = ((HTTPArgument)arg).isAlwaysEncoded();
            if (OPERATION_NAME_FIELD.equals(name)) {
                operationName = GraphQLRequestParamUtils.encodedField(value, encoding, alwaysEncoded);
                continue;
            }
            if (QUERY_FIELD.equals(name)) {
                query = GraphQLRequestParamUtils.encodedField(value, encoding, alwaysEncoded);
                continue;
            }
            if (!VARIABLES_FIELD.equals(name)) continue;
            variables = GraphQLRequestParamUtils.encodedField(value, encoding, alwaysEncoded);
        }
        if (GraphQLRequestParamUtils.isNoQueryOrMutation(query)) {
            throw new IllegalArgumentException("Not a valid GraphQL query.");
        }
        if (GraphQLRequestParamUtils.isNoJsonObject(variables)) {
            throw new IllegalArgumentException("Not a valid object node for GraphQL variables.");
        }
        return new GraphQLRequestParams(operationName, query, variables);
    }

    private static String encodedField(String value, String encoding, boolean isEncoded) throws UnsupportedEncodingException {
        if (isEncoded) {
            return value;
        }
        return URLDecoder.decode(value, encoding);
    }

    private static boolean isNoJsonObject(String variables) {
        return StringUtils.isNotEmpty((CharSequence)variables) && (!StringUtils.startsWith((CharSequence)variables, (CharSequence)"{") || !StringUtils.endsWith((CharSequence)variables, (CharSequence)"}"));
    }

    private static boolean isNoQueryOrMutation(String query) {
        return StringUtils.isEmpty((CharSequence)query) || !StringUtils.startsWith((CharSequence)query, (CharSequence)QUERY_FIELD) && !StringUtils.startsWith((CharSequence)query, (CharSequence)"mutation");
    }

    private static String getJsonNodeTextContent(JsonNode jsonNode, boolean nullable) {
        JsonNodeType nodeType = jsonNode.getNodeType();
        if (nodeType == JsonNodeType.NULL) {
            if (nullable) {
                return null;
            }
            throw new IllegalArgumentException("Not a non-null value node.");
        }
        if (nodeType == JsonNodeType.STRING) {
            return jsonNode.asText();
        }
        throw new IllegalArgumentException("Not a string value node.");
    }
}

