/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.gui.action;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.control.ReplaceableController;
import org.apache.jmeter.control.gui.TestPlanGui;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.plugin.MenuCreator;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.EscapeDialog;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.control.gui.HttpTestSampleGui;
import org.apache.jmeter.protocol.http.curl.BasicCurlParser;
import org.apache.jmeter.protocol.http.gui.HeaderPanel;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerFactory;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerProxy;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.threads.gui.ThreadGroupGui;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.ViewResultsFullVisualizer;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.gui.ComponentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseCurlCommandAction
extends AbstractAction
implements MenuCreator,
ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParseCurlCommandAction.class);
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final Set<String> commands = new HashSet<String>();
    public static final String IMPORT_CURL = "import_curl";
    private static final String CREATE_REQUEST = "CREATE_REQUEST";
    private JSyntaxTextArea cURLCommandTA;
    private JLabel statusText;

    public void doAction(ActionEvent e) {
        this.showInputDialog();
    }

    private final void showInputDialog() {
        EscapeDialog messageDialog = new EscapeDialog((Frame)GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString((String)"curl_import"), false);
        Container contentPane = messageDialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.statusText = new JLabel("", 0);
        this.statusText.setForeground(Color.RED);
        contentPane.add((Component)this.statusText, "North");
        this.cURLCommandTA = JSyntaxTextArea.getInstance((int)10, (int)80, (boolean)false);
        this.cURLCommandTA.setCaretPosition(0);
        contentPane.add((Component)JTextScrollPane.getInstance((JSyntaxTextArea)this.cURLCommandTA), "Center");
        JPanel buttonPanel = new JPanel(new GridLayout(1, 1));
        JButton button = new JButton(JMeterUtils.getResString((String)"curl_create_request"));
        button.setActionCommand(CREATE_REQUEST);
        button.addActionListener(this);
        buttonPanel.add(button);
        contentPane.add((Component)buttonPanel, "South");
        messageDialog.pack();
        ComponentUtil.centerComponentInComponent((Component)GuiPackage.getInstance().getMainFrame(), (Component)messageDialog);
        SwingUtilities.invokeLater(() -> messageDialog.setVisible(true));
    }

    private JMeterTreeNode findFirstNodeOfType(Class<?> type) {
        JMeterTreeModel treeModel = GuiPackage.getInstance().getTreeModel();
        return treeModel.getNodesOfType(type).stream().filter(JMeterTreeNode::isEnabled).findFirst().orElse(null);
    }

    private void createTestPlan(ActionEvent e, BasicCurlParser.Request request) throws MalformedURLException, IllegalUserActionException {
        ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "close"));
        GuiPackage guiPackage = GuiPackage.getInstance();
        guiPackage.clearTestPlan();
        FileServer.getFileServer().setScriptName(null);
        ThreadGroup threadGroup = new ThreadGroup();
        threadGroup.setProperty("TestElement.gui_class", ThreadGroupGui.class.getName());
        threadGroup.setProperty("TestElement.name", "Thread Group");
        threadGroup.setNumThreads(10);
        threadGroup.setRampUp(10);
        threadGroup.setScheduler(true);
        threadGroup.setDuration(3600L);
        threadGroup.setDelay(5L);
        LoopController loopCtrl = new LoopController();
        loopCtrl.setLoops(-1);
        loopCtrl.setContinueForever(true);
        threadGroup.setSamplerController(loopCtrl);
        TestPlan testPlan = new TestPlan();
        testPlan.setProperty("TestElement.name", "Test Plan");
        testPlan.setProperty("TestElement.gui_class", TestPlanGui.class.getName());
        HashTree tree = new HashTree();
        HashTree testPlanHT = tree.add((Object)testPlan);
        HashTree threadGroupHT = testPlanHT.add((Object)threadGroup);
        this.createHttpRequest(request, threadGroupHT);
        ResultCollector resultCollector = new ResultCollector();
        resultCollector.setProperty("TestElement.name", "View Results Tree");
        resultCollector.setProperty("TestElement.gui_class", ViewResultsFullVisualizer.class.getName());
        tree.add(tree.getArray()[0], (Object)resultCollector);
        HashTree newTree = guiPackage.addSubTree(tree);
        guiPackage.updateCurrentGui();
        guiPackage.getMainFrame().getTree().setSelectionPath(new TreePath(((JMeterTreeNode)newTree.getArray()[0]).getPath()));
        HashTree subTree = guiPackage.getCurrentSubTree();
        ActionEvent actionEvent = new ActionEvent(subTree.get(subTree.getArray()[subTree.size() - 1]), e.getID(), "sub_tree_loaded");
        ActionRouter.getInstance().actionPerformed(actionEvent);
        ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "expand all"));
    }

    private HTTPSamplerProxy createHttpRequest(BasicCurlParser.Request request, HashTree parentHT) throws MalformedURLException {
        HTTPSamplerProxy httpSampler = this.createSampler(request);
        HashTree samplerHT = parentHT.add((Object)httpSampler);
        samplerHT.add((Object)httpSampler.getHeaderManager());
        return httpSampler;
    }

    private HTTPSamplerProxy createSampler(BasicCurlParser.Request request) throws MalformedURLException {
        HTTPSamplerProxy httpSampler = (HTTPSamplerProxy)HTTPSamplerFactory.newInstance(HTTPSamplerFactory.DEFAULT_CLASSNAME);
        httpSampler.setProperty("TestElement.gui_class", HttpTestSampleGui.class.getName());
        httpSampler.setProperty("TestElement.name", "HTTP Request");
        httpSampler.setProperty("TestPlan.comments", "Created from cURL on " + LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME));
        httpSampler.setProtocol(new URL(request.getUrl()).getProtocol());
        httpSampler.setPath(request.getUrl());
        httpSampler.setUseKeepAlive(true);
        httpSampler.setFollowRedirects(true);
        httpSampler.setMethod(request.getMethod());
        if (!"GET".equals(request.getMethod())) {
            Arguments arguments = new Arguments();
            httpSampler.setArguments(arguments);
            httpSampler.addNonEncodedArgument("", request.getPostData(), "");
        }
        HeaderManager headerManager = this.createHeaderManager(request);
        httpSampler.addTestElement((TestElement)headerManager);
        return httpSampler;
    }

    private HeaderManager createHeaderManager(BasicCurlParser.Request request) {
        HeaderManager headerManager = new HeaderManager();
        headerManager.setProperty("TestElement.gui_class", HeaderPanel.class.getName());
        headerManager.setProperty("TestElement.name", "HTTP HeaderManager");
        headerManager.setProperty("TestPlan.comments", "Created from cURL on " + LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME));
        Map<String, String> map = request.getHeaders();
        boolean hasAcceptEncoding = false;
        for (Map.Entry<String, String> header : map.entrySet()) {
            String key = header.getKey();
            hasAcceptEncoding = hasAcceptEncoding || key.equalsIgnoreCase(ACCEPT_ENCODING);
            headerManager.getHeaders().addItem((Object)new Header(key, header.getValue()));
        }
        if (!hasAcceptEncoding && request.isCompressed()) {
            headerManager.getHeaders().addItem((Object)new Header(ACCEPT_ENCODING, "gzip, deflate"));
        }
        return headerManager;
    }

    public Set<String> getActionNames() {
        return commands;
    }

    public JMenuItem[] getMenuItemsAtLocation(MenuCreator.MENU_LOCATION location) {
        if (location == MenuCreator.MENU_LOCATION.TOOLS) {
            JMenuItem menuItemIC = new JMenuItem(JMeterUtils.getResString((String)"curl_import_menu"), 0);
            menuItemIC.setName(IMPORT_CURL);
            menuItemIC.setActionCommand(IMPORT_CURL);
            menuItemIC.setAccelerator(null);
            menuItemIC.addActionListener((ActionListener)ActionRouter.getInstance());
            return new JMenuItem[]{menuItemIC};
        }
        return new JMenuItem[0];
    }

    public JMenu[] getTopLevelMenus() {
        return new JMenu[0];
    }

    public boolean localeChanged(MenuElement menu) {
        return false;
    }

    public void localeChanged() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.statusText.setText("");
        this.statusText.setForeground(Color.GREEN);
        if (e.getActionCommand().equals(CREATE_REQUEST)) {
            String curlCommand = this.cURLCommandTA.getText();
            try {
                LOGGER.info("Transforming CURL command {}", (Object)curlCommand);
                BasicCurlParser basicCurlParser = new BasicCurlParser();
                BasicCurlParser.Request request = basicCurlParser.parse(curlCommand);
                LOGGER.info("Parsed CURL command {} into {}", (Object)curlCommand, (Object)request);
                GuiPackage guiPackage = GuiPackage.getInstance();
                guiPackage.updateCurrentNode();
                JMeterTreeNode treeNode = this.findFirstNodeOfType(AbstractThreadGroup.class);
                if (treeNode == null) {
                    LOGGER.info("No AbstractThreadGroup found, potentially empty plan, creating a new plan");
                    this.createTestPlan(e, request);
                } else {
                    JMeterTreeNode currentNode = guiPackage.getCurrentNode();
                    Object userObject = currentNode.getUserObject();
                    if (userObject instanceof Controller && !(userObject instanceof ReplaceableController)) {
                        LOGGER.info("Newly created element will be placed under current selected node {}", (Object)currentNode.getName());
                        this.addToTestPlan(currentNode, request);
                    } else {
                        LOGGER.info("Newly created element will be placed under first AbstractThreadGroup node {}", (Object)treeNode.getName());
                        this.addToTestPlan(treeNode, request);
                    }
                }
                this.statusText.setText(JMeterUtils.getResString((String)"curl_create_success"));
            }
            catch (Exception ex) {
                LOGGER.error("Error creating test plan from cURL command:{}, error:{}", new Object[]{curlCommand, ex.getMessage(), ex});
                this.statusText.setText(MessageFormat.format(JMeterUtils.getResString((String)"curl_create_failure"), ex.getMessage()));
                this.statusText.setForeground(Color.RED);
            }
        }
    }

    private void addToTestPlan(JMeterTreeNode currentNode, BasicCurlParser.Request request) throws MalformedURLException {
        HTTPSamplerProxy sampler = this.createSampler(request);
        JMeterTreeModel treeModel = GuiPackage.getInstance().getTreeModel();
        JMeterUtils.runSafe((boolean)true, () -> {
            try {
                HeaderManager headerManager = sampler.getHeaderManager();
                JMeterTreeNode newNode = treeModel.addComponent((TestElement)sampler, currentNode);
                treeModel.addComponent((TestElement)headerManager, newNode);
            }
            catch (IllegalUserActionException ex) {
                LOGGER.error("Error placing sampler", (Throwable)ex);
                JMeterUtils.reportErrorToUser((String)ex.getMessage());
            }
        });
    }

    static {
        commands.add(IMPORT_CURL);
    }
}

