/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.FileWrapper;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class CSVRead
extends AbstractFunction {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String KEY = "__CSVRead";
    private static final List<String> desc = new LinkedList<String>();
    private Object[] values;

    public synchronized String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        String myValue = "";
        String fileName = ((CompoundVariable)this.values[0]).execute();
        String columnOrNext = ((CompoundVariable)this.values[1]).execute();
        log.debug("execute (" + fileName + " , " + columnOrNext + ")   ");
        if (columnOrNext.startsWith("*")) {
            FileWrapper.open(fileName, columnOrNext);
            return "";
        }
        if (columnOrNext.equals("next()") || columnOrNext.equals("next")) {
            FileWrapper.endRow(fileName);
            return "";
        }
        try {
            int columnIndex = Integer.parseInt(columnOrNext);
            myValue = FileWrapper.getColumn(fileName, columnIndex);
        }
        catch (NumberFormatException e) {
            log.warn(Thread.currentThread().getName() + " - can't parse column number: " + columnOrNext + " " + e.toString());
        }
        catch (IndexOutOfBoundsException e) {
            log.warn(Thread.currentThread().getName() + " - invalid column number: " + columnOrNext + " at row " + FileWrapper.getCurrentRow(fileName) + " " + e.toString());
        }
        log.debug("execute value: " + myValue);
        return myValue;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    public String getReferenceKey() {
        return KEY;
    }

    public synchronized void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        log.debug("setParameter - Collection.size=" + parameters.size());
        this.values = parameters.toArray();
        if (log.isDebugEnabled()) {
            for (int i = 0; i < parameters.size(); ++i) {
                log.debug("i:" + ((CompoundVariable)this.values[i]).execute());
            }
        }
        this.checkParameterCount(parameters, 2);
        FileWrapper.clearAll();
    }

    static {
        desc.add(JMeterUtils.getResString((String)"csvread_file_file_name"));
        desc.add(JMeterUtils.getResString((String)"column_number"));
    }
}

