/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriticalSectionController
extends GenericController
implements ThreadListener,
TestStateListener {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(CriticalSectionController.class);
    private static final String LOCK_NAME = "CriticalSectionController.lockName";
    private static final ConcurrentHashMap<String, ReentrantLock> LOCK_MAP = new ConcurrentHashMap();
    private volatile transient ReentrantLock currentLock;

    public CriticalSectionController() {
    }

    public CriticalSectionController(String name) {
        this.setName(name);
    }

    public void setLockName(String name) {
        this.setProperty((JMeterProperty)new StringProperty(LOCK_NAME, name));
    }

    private ReentrantLock getOrCreateLock() {
        String lockName = this.getLockName();
        ReentrantLock lock = LOCK_MAP.get(lockName);
        if (lock != null) {
            return lock;
        }
        lock = new ReentrantLock();
        ReentrantLock prev = LOCK_MAP.putIfAbsent(lockName, lock);
        return prev == null ? lock : prev;
    }

    public String getLockName() {
        return this.getPropertyAsString(LOCK_NAME);
    }

    public Sampler next() {
        if (StringUtils.isEmpty((CharSequence)this.getLockName())) {
            if (log.isWarnEnabled()) {
                log.warn("Empty lock name in Critical Section Controller: {}", (Object)this.getName());
            }
            return super.next();
        }
        if (this.isFirst()) {
            long startTime = System.currentTimeMillis();
            if (this.currentLock == null) {
                this.currentLock = this.getOrCreateLock();
            }
            this.currentLock.lock();
            long endTime = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug("Thread ('{}') acquired lock: '{}' in Critical Section Controller {}  in: {} ms", new Object[]{Thread.currentThread(), this.getLockName(), this.getName(), endTime - startTime});
            }
        }
        return super.next();
    }

    protected void reInitialize() {
        if (this.currentLock != null) {
            if (this.currentLock.isHeldByCurrentThread()) {
                this.currentLock.unlock();
            }
            this.currentLock = null;
        }
        super.reInitialize();
    }

    public void threadStarted() {
        this.currentLock = null;
    }

    public void threadFinished() {
        if (this.currentLock != null && this.currentLock.isHeldByCurrentThread()) {
            if (log.isWarnEnabled()) {
                log.warn("Lock '{}' not released in: {}, releasing in threadFinished", (Object)this.getLockName(), (Object)this.getName());
            }
            this.currentLock.unlock();
        }
        this.currentLock = null;
    }

    public void testStarted() {
    }

    public void testStarted(String host) {
    }

    public void testEnded() {
        LOCK_MAP.clear();
    }

    public void testEnded(String host) {
        this.testEnded();
    }
}

