/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor.json.jmespath;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.extractor.json.jmespath.JMESPathCache;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMESPathExtractor
extends AbstractScopedTestElement
implements Serializable,
PostProcessor,
TestStateListener {
    private static final long serialVersionUID = 3849270294526207081L;
    private static final Logger log = LoggerFactory.getLogger(JMESPathExtractor.class);
    private static final String JMES_PATH_EXPRESSION = "JMESExtractor.jmesPathExpr";
    private static final String REFERENCE_NAME = "JMESExtractor.referenceName";
    private static final String DEFAULT_VALUE = "JMESExtractor.defaultValue";
    private static final String MATCH_NUMBER = "JMESExtractor.matchNumber";
    private static final String REF_MATCH_NR = "_matchNr";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public void process() {
        JMeterContext context = this.getThreadContext();
        JMeterVariables vars = context.getVariables();
        String jsonResponse = this.getData(vars, context);
        String refName = this.getRefName();
        String defaultValue = this.getDefaultValue();
        int matchNumber = Integer.parseInt(this.getMatchNumber());
        String jsonPathExpression = this.getJmesPathExpression().trim();
        this.clearOldRefVars(vars, refName);
        if (StringUtils.isEmpty((CharSequence)jsonResponse)) {
            this.handleEmptyResponse(vars, refName, defaultValue);
            return;
        }
        try {
            JsonNode actualObj = (JsonNode)OBJECT_MAPPER.readValue(jsonResponse, JsonNode.class);
            JsonNode result = (JsonNode)JMESPathCache.getInstance().get(jsonPathExpression).search((Object)actualObj);
            if (result.isNull()) {
                this.handleNullResult(vars, refName, defaultValue, matchNumber);
                return;
            }
            List<String> resultList = this.splitJson(result);
            if (resultList.size() > 1) {
                this.handleListResult(vars, refName, defaultValue, matchNumber, resultList);
            } else {
                this.handleSingleResult(vars, refName, matchNumber, resultList);
            }
            vars.put(refName + REF_MATCH_NR, Integer.toString(resultList.size()));
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error("Error processing JSON content in {}, message: {}", new Object[]{this.getName(), e.getLocalizedMessage(), e});
            } else {
                log.error("Error processing JSON content in {}, message: {}", (Object)this.getName(), (Object)e.getLocalizedMessage());
            }
            vars.put(refName, defaultValue);
        }
    }

    private void handleSingleResult(JMeterVariables vars, String refName, int matchNumber, List<String> resultList) {
        String suffix = matchNumber < 0 ? "_1" : "";
        this.placeObjectIntoVars(vars, refName + suffix, resultList, 0);
    }

    private void handleListResult(JMeterVariables vars, String refName, String defaultValue, int matchNumber, List<String> resultList) {
        if (matchNumber < 0) {
            int index = 1;
            for (String extractedString : resultList) {
                vars.put(refName + "_" + index, extractedString);
                ++index;
            }
        } else if (matchNumber == 0) {
            int matchSize = resultList.size();
            int matchNr = JMeterUtils.getRandomInt((int)matchSize);
            this.placeObjectIntoVars(vars, refName, resultList, matchNr);
        } else if (matchNumber > resultList.size()) {
            if (log.isDebugEnabled()) {
                log.debug("matchNumber({}) exceeds number of items found({}), default value will be used", (Object)matchNumber, (Object)resultList.size());
            }
            vars.put(refName, defaultValue);
        } else {
            this.placeObjectIntoVars(vars, refName, resultList, matchNumber - 1);
        }
    }

    private void handleNullResult(JMeterVariables vars, String refName, String defaultValue, int matchNumber) {
        vars.put(refName, defaultValue);
        vars.put(refName + REF_MATCH_NR, "0");
        if (matchNumber < 0) {
            log.debug("No value extracted, storing empty in: {}", (Object)refName);
        }
    }

    private void handleEmptyResponse(JMeterVariables vars, String refName, String defaultValue) {
        if (log.isDebugEnabled()) {
            log.debug("Response or source variable is null or empty for {}", (Object)this.getName());
        }
        vars.put(refName, defaultValue);
    }

    private String getData(JMeterVariables vars, JMeterContext context) {
        String jsonResponse = null;
        if (this.isScopeVariable()) {
            jsonResponse = vars.get(this.getVariableName());
            if (log.isDebugEnabled()) {
                log.debug("JMESExtractor is using variable: {}, which content is: {}", (Object)this.getVariableName(), (Object)jsonResponse);
            }
        } else {
            SampleResult previousResult = context.getPreviousResult();
            if (previousResult != null) {
                jsonResponse = previousResult.getResponseDataAsString();
            }
            if (log.isDebugEnabled()) {
                log.debug("JMESExtractor {} working on Response: {}", (Object)this.getName(), (Object)jsonResponse);
            }
        }
        return jsonResponse;
    }

    public List<String> splitJson(JsonNode jsonNode) throws IOException {
        ArrayList<String> splittedJsonElements = new ArrayList<String>();
        if (jsonNode.isArray()) {
            for (JsonNode element : (ArrayNode)jsonNode) {
                splittedJsonElements.add(JMESPathExtractor.writeJsonNode(OBJECT_MAPPER, element));
            }
        } else {
            splittedJsonElements.add(JMESPathExtractor.writeJsonNode(OBJECT_MAPPER, jsonNode));
        }
        return splittedJsonElements;
    }

    private static String writeJsonNode(ObjectMapper mapper, JsonNode element) throws JsonProcessingException {
        if (element.isTextual()) {
            return element.asText();
        }
        return mapper.writeValueAsString((Object)element);
    }

    void clearOldRefVars(JMeterVariables vars, String refName) {
        vars.remove(refName + REF_MATCH_NR);
        int i = 1;
        while (vars.get(refName + "_" + i) != null) {
            vars.remove(refName + "_" + i);
            ++i;
        }
    }

    private void placeObjectIntoVars(JMeterVariables vars, String refName, List<String> extractedValues, int matchNr) {
        vars.put(refName, extractedValues.get(matchNr));
    }

    public String getJmesPathExpression() {
        return this.getPropertyAsString(JMES_PATH_EXPRESSION);
    }

    public void setJmesPathExpression(String jsonPath) {
        this.setProperty(JMES_PATH_EXPRESSION, jsonPath);
    }

    public String getRefName() {
        return this.getPropertyAsString(REFERENCE_NAME);
    }

    public void setRefName(String refName) {
        this.setProperty(REFERENCE_NAME, refName);
    }

    public String getDefaultValue() {
        return this.getPropertyAsString(DEFAULT_VALUE);
    }

    public void setDefaultValue(String defaultValue) {
        this.setProperty(DEFAULT_VALUE, defaultValue, "");
    }

    public void setMatchNumber(String matchNumber) {
        this.setProperty(MATCH_NUMBER, matchNumber);
    }

    public String getMatchNumber() {
        return this.getPropertyAsString(MATCH_NUMBER);
    }

    public void testStarted() {
        this.testStarted("");
    }

    public void testStarted(String host) {
    }

    public void testEnded() {
        this.testEnded("");
    }

    public void testEnded(String host) {
        JMESPathCache.getInstance().cleanUp();
    }
}

