/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.jmeter.DynamicClassLoader;

public final class NewDriver {
    private static final String CLASSPATH_SEPARATOR;
    private static final String OS_NAME;
    private static final String OS_NAME_LC;
    private static final String JAVA_CLASS_PATH = "java.class.path";
    private static final DynamicClassLoader loader;
    private static final String JMETER_INSTALLATION_DIRECTORY;
    private static final List<Exception> EXCEPTIONS_IN_INIT;

    private NewDriver() {
    }

    private static File[] listJars(File dir) {
        if (dir.isDirectory()) {
            return dir.listFiles((f, name) -> {
                if (name.endsWith(".jar")) {
                    File jar = new File(f, name);
                    return jar.isFile() && jar.canRead();
                }
                return false;
            });
        }
        return new File[0];
    }

    public static void addURL(String path) throws MalformedURLException {
        File[] jars;
        File furl = new File(path);
        loader.addURL(furl.toURI().toURL());
        for (File jar : jars = NewDriver.listJars(furl)) {
            loader.addURL(jar.toURI().toURL());
        }
    }

    public static void addURL(URL url) {
        loader.addURL(url);
    }

    public static void addPath(String path) throws MalformedURLException {
        File[] jars;
        File file = new File(path);
        if (file.isDirectory() && !path.endsWith("/")) {
            file = new File(path + "/");
        }
        loader.addURL(file.toURI().toURL());
        StringBuilder sb = new StringBuilder(System.getProperty(JAVA_CLASS_PATH));
        sb.append(CLASSPATH_SEPARATOR);
        sb.append(path);
        for (File jar : jars = NewDriver.listJars(file)) {
            loader.addURL(jar.toURI().toURL());
            sb.append(CLASSPATH_SEPARATOR);
            sb.append(jar.getPath());
        }
        System.setProperty(JAVA_CLASS_PATH, sb.toString());
    }

    public static String getJMeterDir() {
        return JMETER_INSTALLATION_DIRECTORY;
    }

    public static void main(String[] args) {
        if (!EXCEPTIONS_IN_INIT.isEmpty()) {
            System.err.println("Configuration error during init, see exceptions:" + NewDriver.exceptionsToString(EXCEPTIONS_IN_INIT));
        } else {
            Thread.currentThread().setContextClassLoader(loader);
            NewDriver.setLoggingProperties(args);
            try {
                Class<?> initialClass = loader.loadClass("org.apache.jmeter.JMeter");
                Object instance = initialClass.newInstance();
                Method startup = initialClass.getMethod("start", new String[0].getClass());
                startup.invoke(instance, new Object[]{args});
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.err.println("JMeter home directory was detected as: " + JMETER_INSTALLATION_DIRECTORY);
            }
        }
    }

    private static String exceptionsToString(List<Exception> exceptionsInInit) {
        StringBuilder builder = new StringBuilder();
        for (Exception exception : exceptionsInInit) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            builder.append(stringWriter.toString()).append("\r\n");
        }
        return builder.toString();
    }

    private static void setLoggingProperties(String[] args) {
        String jmLogFile = NewDriver.getCommandLineArgument(args, 106, "jmeterlogfile");
        if (jmLogFile != null && !jmLogFile.isEmpty()) {
            jmLogFile = NewDriver.replaceDateFormatInFileName(jmLogFile);
            System.setProperty("jmeter.logfile", jmLogFile);
        } else if (System.getProperty("jmeter.logfile") == null) {
            System.setProperty("jmeter.logfile", "jmeter.log");
        }
        String jmLogConf = NewDriver.getCommandLineArgument(args, 105, "jmeterlogconf");
        File logConfFile = null;
        if (jmLogConf != null && !jmLogConf.isEmpty()) {
            logConfFile = new File(jmLogConf);
        } else if (System.getProperty("log4j.configurationFile") == null && !(logConfFile = new File("log4j2.xml")).isFile()) {
            logConfFile = new File(JMETER_INSTALLATION_DIRECTORY, "bin" + File.separator + "log4j2.xml");
        }
        if (logConfFile != null) {
            System.setProperty("log4j.configurationFile", logConfFile.toURI().toString());
        }
    }

    private static String getCommandLineArgument(String[] args, int id, String name) {
        String shortArgName = "-" + (char)id;
        String longArgName = "--" + name;
        String value = null;
        for (int i = 0; i < args.length; ++i) {
            if (shortArgName.equals(args[i]) && i < args.length - 1) {
                if (args[i + 1].startsWith("-")) break;
                value = args[i + 1];
                break;
            }
            if (!shortArgName.equals(args[i]) && args[i].startsWith(shortArgName)) {
                value = args[i].substring(shortArgName.length());
                break;
            }
            if (!longArgName.equals(args[i])) continue;
            if (args[i + 1].startsWith("-")) break;
            value = args[i + 1];
            break;
        }
        return value;
    }

    private static String replaceDateFormatInFileName(String fileName) {
        try {
            StringBuilder builder = new StringBuilder();
            Date date = new Date();
            int fromIndex = 0;
            int begin = fileName.indexOf(39, fromIndex);
            while (begin != -1) {
                builder.append(fileName.substring(fromIndex, begin));
                fromIndex = begin + 1;
                int end = fileName.indexOf(39, fromIndex);
                if (end == -1) {
                    throw new IllegalArgumentException("Invalid pairs of single-quotes in the file name: " + fileName);
                }
                String format = fileName.substring(begin + 1, end);
                SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                builder.append(dateFormat.format(date));
                fromIndex = end + 1;
                begin = fileName.indexOf(39, fromIndex);
            }
            if (fromIndex < fileName.length() - 1) {
                builder.append(fileName.substring(fromIndex));
            }
            return builder.toString();
        }
        catch (Exception ex) {
            System.err.println("Error replacing date format in file name:" + fileName + ", error:" + ex.getMessage());
            return fileName;
        }
    }

    static {
        File[] libDirs;
        CLASSPATH_SEPARATOR = File.pathSeparator;
        OS_NAME = System.getProperty("os.name");
        OS_NAME_LC = OS_NAME.toLowerCase(Locale.ENGLISH);
        EXCEPTIONS_IN_INIT = new ArrayList<Exception>();
        final LinkedList<URL> jars = new LinkedList<URL>();
        String initial_classpath = System.getProperty(JAVA_CLASS_PATH);
        String tmpDir = null;
        StringTokenizer tok = new StringTokenizer(initial_classpath, File.pathSeparator);
        if (tok.countTokens() == 1 || tok.countTokens() == 2 && OS_NAME_LC.startsWith("mac os x")) {
            File jar = new File(tok.nextToken());
            try {
                tmpDir = jar.getCanonicalFile().getParentFile().getParent();
            }
            catch (IOException iOException) {}
        } else {
            tmpDir = System.getProperty("jmeter.home", "");
            if (tmpDir.length() == 0) {
                File userDir = new File(System.getProperty("user.dir"));
                tmpDir = userDir.getAbsoluteFile().getParent();
            }
        }
        JMETER_INSTALLATION_DIRECTORY = tmpDir;
        boolean usesUNC = OS_NAME_LC.startsWith("windows");
        StringBuilder classpath = new StringBuilder();
        for (File libDir : libDirs = new File[]{new File(JMETER_INSTALLATION_DIRECTORY + File.separator + "lib"), new File(JMETER_INSTALLATION_DIRECTORY + File.separator + "lib" + File.separator + "ext"), new File(JMETER_INSTALLATION_DIRECTORY + File.separator + "lib" + File.separator + "junit")}) {
            Object[] libJars = libDir.listFiles((dir, name) -> name.endsWith(".jar"));
            if (libJars == null) {
                new Throwable("Could not access " + libDir).printStackTrace();
                continue;
            }
            Arrays.sort(libJars);
            for (Object libJar : libJars) {
                try {
                    String s = ((File)libJar).getPath();
                    if (usesUNC) {
                        if (s.startsWith("\\\\") && !s.startsWith("\\\\\\")) {
                            s = "\\\\" + s;
                        } else if (s.startsWith("//") && !s.startsWith("///")) {
                            s = "//" + s;
                        }
                    }
                    jars.add(new File(s).toURI().toURL());
                    classpath.append(CLASSPATH_SEPARATOR);
                    classpath.append(s);
                }
                catch (MalformedURLException e) {
                    EXCEPTIONS_IN_INIT.add(new Exception("Error adding jar:" + ((File)libJar).getAbsolutePath(), e));
                }
            }
        }
        System.setProperty(JAVA_CLASS_PATH, initial_classpath + classpath.toString());
        loader = AccessController.doPrivileged(new PrivilegedAction<DynamicClassLoader>(){

            @Override
            public DynamicClassLoader run() {
                return new DynamicClassLoader(jars.toArray(new URL[jars.size()]));
            }
        });
    }
}

