/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.assembler;

import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.assembler.Params;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class GenericFilterAssembler
extends AssemblerBase {
    public FilterSpec open(Assembler a, Resource root, Mode mode) {
        if (root.hasProperty(TextVocab.pClass)) {
            String className = root.getProperty(TextVocab.pClass).getString();
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                Log.error((Object)((Object)this), (String)("Filter class " + className + " not found. " + e.getMessage()), (Throwable)e);
                return null;
            }
            if (!TokenFilter.class.isAssignableFrom(clazz)) {
                Log.error((Object)((Object)this), (String)(clazz.getName() + " has to be a subclass of " + TokenFilter.class.getName()));
                return null;
            }
            if (root.hasProperty(TextVocab.pParams)) {
                RDFNode node = root.getProperty(TextVocab.pParams).getObject();
                if (!node.isResource()) {
                    throw new TextIndexException("text:params must be a list of parameter resources: " + String.valueOf(node));
                }
                List<Params.ParamSpec> specs = Params.getParamSpecs((Resource)node);
                Class[] paramClasses = new Class[specs.size() + 1];
                paramClasses[0] = TokenStream.class;
                Object[] paramValues = new Object[specs.size() + 1];
                paramValues[0] = null;
                for (int i = 0; i < specs.size(); ++i) {
                    Params.ParamSpec spec = specs.get(i);
                    paramClasses[i + 1] = spec.getValueClass();
                    paramValues[i + 1] = spec.getValue();
                }
                return new FilterSpec(clazz, paramClasses, paramValues);
            }
            return new FilterSpec(clazz, new Class[]{TokenStream.class}, new Object[]{null});
        }
        throw new TextIndexException("text:class property is required by GenericFilter: " + String.valueOf(root));
    }

    public static class FilterSpec {
        public Class<?> clazz;
        public Class<?>[] paramClasses;
        public Object[] paramValues;

        public FilterSpec(Class<?> clazz, Class<?>[] paramClasses, Object[] paramValues) {
            this.clazz = clazz;
            this.paramClasses = paramClasses;
            this.paramValues = paramValues;
        }
    }
}

