/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.MultiMapUtils;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.query.text.DatasetGraphText;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextHit;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.TextQuery;
import org.apache.jena.query.text.TextQueryFuncs;
import org.apache.jena.query.text.analyzer.Util;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.NamedGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIterSlice;
import org.apache.jena.sparql.mgt.Explain;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunctionBase;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.IterLib;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.sparql.util.Symbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextQueryPF
extends PropertyFunctionBase {
    private static Logger log = LoggerFactory.getLogger(TextQueryPF.class);
    private TextIndex textIndex = null;
    private boolean warningIssued = false;
    private static final Symbol cacheSymbol = Symbol.create((String)"TextQueryPF.cache");
    private static final int CACHE_SIZE = 10;

    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        int size;
        super.build(argSubject, predicate, argObject, execCxt);
        DatasetGraph dsg = execCxt.getDataset();
        this.textIndex = TextQueryPF.chooseTextIndex(execCxt, dsg);
        if (argSubject.isList() && ((size = argSubject.getArgListSize()) == 0 || size > 5)) {
            throw new QueryBuildException("Subject has " + argSubject.getArgList().size() + " elements, must be at least 1 and not greater than 4: " + String.valueOf(argSubject));
        }
        if (argObject.isList()) {
            int numProps;
            List list = argObject.getArgList();
            int sz = list.size();
            if (sz == 0) {
                throw new QueryBuildException("Zero-length argument list");
            }
            for (numProps = 0; numProps < sz && ((Node)list.get(numProps)).isURI(); ++numProps) {
            }
            if (sz - numProps < 1) {
                throw new QueryBuildException("No query string just properties in list : " + String.valueOf(list));
            }
            if (sz - numProps > 4) {
                throw new QueryBuildException("Too many arguments in list : " + String.valueOf(list));
            }
        }
    }

    private static TextIndex chooseTextIndex(ExecutionContext execCxt, DatasetGraph dsg) {
        Object obj = execCxt.getContext().get(TextQuery.textIndex);
        if (obj instanceof TextIndex) {
            return (TextIndex)obj;
        }
        if (obj != null) {
            Log.warn(TextQueryPF.class, (String)("Context setting '" + String.valueOf(TextQuery.textIndex) + "' is not a TextIndex"));
        }
        if (dsg instanceof DatasetGraphText) {
            DatasetGraphText x = (DatasetGraphText)dsg;
            return x.getTextIndex();
        }
        Log.warn(TextQueryPF.class, (String)"Failed to find the text index : tried context and as a text-enabled dataset");
        return null;
    }

    private String extractArg(String prefix, List<Node> objArgs) {
        String value = null;
        for (Node node : objArgs) {
            String arg;
            if (!node.isLiteral() || !(arg = node.getLiteral().getLexicalForm()).startsWith(prefix + ":")) continue;
            value = arg.substring(prefix.length() + 1);
            break;
        }
        return value;
    }

    public QueryIterator exec(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        if (log.isTraceEnabled()) {
            IndentedLineBuffer subjBuff = new IndentedLineBuffer();
            argSubject.output((IndentedWriter)subjBuff, null);
            IndentedLineBuffer objBuff = new IndentedLineBuffer();
            argObject.output((IndentedWriter)objBuff, null);
            log.trace("exec: {} text:query {}", (Object)subjBuff, (Object)objBuff);
        }
        if (this.textIndex == null) {
            if (!this.warningIssued) {
                Log.warn(((Object)((Object)this)).getClass(), (String)"No text index - no text search performed");
                this.warningIssued = true;
            }
            return IterLib.result((Binding)binding, (ExecutionContext)execCxt);
        }
        argSubject = Substitute.substitute((PropFuncArg)argSubject, (Binding)binding);
        argObject = Substitute.substitute((PropFuncArg)argObject, (Binding)binding);
        Node s = null;
        Node score = null;
        Node literal = null;
        Node graph = null;
        Node prop = null;
        if (argSubject.isList()) {
            s = argSubject.getArg(0);
            if (argSubject.getArgListSize() > 1 && !(score = argSubject.getArg(1)).isVariable()) {
                throw new QueryExecException("Hit score is not a variable: " + String.valueOf(argSubject));
            }
            if (argSubject.getArgListSize() > 2 && !(literal = argSubject.getArg(2)).isVariable()) {
                throw new QueryExecException("Hit literal is not a variable: " + String.valueOf(argSubject));
            }
            if (argSubject.getArgListSize() > 3 && !(graph = argSubject.getArg(3)).isVariable()) {
                throw new QueryExecException("Hit graph is not a variable: " + String.valueOf(argSubject));
            }
            if (argSubject.getArgListSize() > 4 && !(prop = argSubject.getArg(4)).isVariable()) {
                throw new QueryExecException("Hit prop is not a variable: " + String.valueOf(argSubject));
            }
        } else {
            s = argSubject.getArg();
        }
        if (s.isLiteral()) {
            return IterLib.noResults((ExecutionContext)execCxt);
        }
        StrMatch match = this.objectToStruct(argObject, true);
        if (match == null) {
            return IterLib.noResults((ExecutionContext)execCxt);
        }
        QueryIterator qIter = this.prepareQuery(binding, s, score, literal, graph, prop, match, execCxt);
        if (match.getLimit() >= 0) {
            qIter = new QueryIterSlice(qIter, 0L, (long)match.getLimit(), execCxt);
        }
        return qIter;
    }

    private static void addIf(BindingBuilder builder, Var var, Node node) {
        if (var != null && node != null) {
            builder.add(var, node);
        }
    }

    private QueryIterator resultsToQueryIterator(Binding binding, Node subj, Node score, Node literal, Node graph, Node prop, Collection<TextHit> results, ExecutionContext execCxt) {
        log.trace("resultsToQueryIterator CALLED with results: {}", results);
        Var sVar = Var.isVar((Node)subj) ? Var.alloc((Node)subj) : null;
        Var scoreVar = score == null ? null : Var.alloc((Node)score);
        Var literalVar = literal == null ? null : Var.alloc((Node)literal);
        Var graphVar = graph == null ? null : Var.alloc((Node)graph);
        Var propVar = prop == null ? null : Var.alloc((Node)prop);
        Function<TextHit, Binding> converter = hit -> {
            if (score == null && literal == null) {
                return sVar != null ? BindingFactory.binding((Binding)binding, (Var)sVar, (Node)hit.getNode()) : BindingFactory.binding((Binding)binding);
            }
            BindingBuilder bmap = Binding.builder((Binding)binding);
            TextQueryPF.addIf(bmap, sVar, hit.getNode());
            TextQueryPF.addIf(bmap, scoreVar, NodeFactoryExtra.floatToNode((float)hit.getScore()));
            TextQueryPF.addIf(bmap, literalVar, hit.getLiteral());
            TextQueryPF.addIf(bmap, graphVar, hit.getGraph());
            TextQueryPF.addIf(bmap, propVar, hit.getProp());
            log.trace("resultsToQueryIterator RETURNING bmap: {}", (Object)bmap);
            return bmap.build();
        };
        Iterator bIter = Iter.map(results.iterator(), converter);
        QueryIterator qIter = QueryIterPlainWrapper.create((Iterator)bIter, (ExecutionContext)execCxt);
        return qIter;
    }

    private QueryIterator prepareQuery(Binding binding, Node subj, Node score, Node literal, Node graph, Node prop, StrMatch match, ExecutionContext execCxt) {
        ListValuedMap<String, TextHit> rezList;
        log.trace("prepareQuery with subject: {}; params: {}", (Object)subj, (Object)match);
        if (!Var.isVar((Node)subj)) {
            match.setQueryLimit(-1);
        }
        if ((rezList = this.query(subj, match, execCxt)) == null) {
            return IterLib.noResults((ExecutionContext)execCxt);
        }
        Collection hits = Var.isVar((Node)subj) ? rezList.values() : rezList.get((Object)TextQueryFuncs.subjectToString(subj));
        return this.resultsToQueryIterator(binding, subj, score, literal, graph, prop, hits, execCxt);
    }

    private ListValuedMap<String, TextHit> query(Node subj, StrMatch match, ExecutionContext execCxt) {
        String graphURI = this.chooseGraphURI(execCxt);
        String qs = match.getQueryString();
        int limit = match.getQueryLimit();
        String lang = match.getLang();
        String highlight = match.getHighlight();
        this.explainQuery(qs, limit, execCxt, graphURI);
        if (this.textIndex.getDocDef().areQueriesCached()) {
            String cacheKey = String.valueOf(subj) + " " + limit + " " + String.valueOf(match.getProps()) + " " + qs + " " + lang + " " + graphURI;
            Cache<String, ListValuedMap<String, TextHit>> queryCache = this.prepareCache(execCxt);
            log.trace("Caching Text query: {} with key: >>{}<< in cache: {}", new Object[]{qs, cacheKey, queryCache});
            return (ListValuedMap)queryCache.get((Object)cacheKey, k -> this.performQuery(subj, match, qs, graphURI, lang, limit, highlight));
        }
        log.trace("Executing w/o cache Text query: {}", (Object)qs);
        return this.performQuery(subj, match, qs, graphURI, lang, limit, highlight);
    }

    private Cache<String, ListValuedMap<String, TextHit>> prepareCache(ExecutionContext execCxt) {
        Cache queryCache = (Cache)execCxt.getContext().get(cacheSymbol);
        if (queryCache == null) {
            queryCache = CacheFactory.createCache((int)10);
            execCxt.getContext().put(cacheSymbol, (Object)queryCache);
        }
        return queryCache;
    }

    private void explainQuery(String queryString, int limit, ExecutionContext execCxt, String graphURI) {
        if (graphURI == null) {
            Explain.explain((Context)execCxt.getContext(), (String)("Text query: " + queryString));
            log.debug("Text query: {} ({})", (Object)queryString, (Object)limit);
        } else {
            Explain.explain((Context)execCxt.getContext(), (String)("Text query <" + graphURI + ">: " + queryString));
            log.debug("Text query: {} <{}> ({})", new Object[]{queryString, graphURI, limit});
        }
    }

    private String chooseGraphURI(ExecutionContext execCxt) {
        NamedGraph namedGraph;
        String graphURI = null;
        Graph activeGraph = execCxt.getActiveGraph();
        if (this.textIndex.getDocDef().getGraphField() != null && activeGraph instanceof NamedGraph && !Quad.isUnionGraph((Node)(namedGraph = (NamedGraph)activeGraph).getGraphName())) {
            graphURI = namedGraph.getGraphName() != null ? TextQueryFuncs.graphNodeToString(namedGraph.getGraphName()) : Quad.defaultGraphNodeGenerated.getURI();
        }
        return graphURI;
    }

    private ListValuedMap<String, TextHit> performQuery(Node subj, StrMatch match, String queryString, String graphURI, String lang, int limit, String highlight) {
        List<TextHit> resultList = null;
        resultList = this.textIndex.query(subj, match.getProps(), queryString, graphURI, lang, limit, highlight);
        return this.mapResult(resultList);
    }

    private ListValuedMap<String, TextHit> mapResult(List<TextHit> resultList) {
        ListValuedMap results = MultiMapUtils.newListValuedHashMap();
        for (TextHit result : resultList) {
            results.put((Object)TextQueryFuncs.subjectToString(result.getNode()), (Object)result);
        }
        return results;
    }

    private boolean isIndexed(List<Resource> props) {
        for (Resource prop : props) {
            if (this.isIndexed(prop.asNode())) continue;
            return false;
        }
        return true;
    }

    private boolean isIndexed(Node predicate) {
        EntityDefinition docDef = this.textIndex.getDocDef();
        String field = docDef.getField(predicate);
        if (field == null) {
            log.warn("Predicate not indexed: " + String.valueOf(predicate));
            return false;
        }
        return true;
    }

    private StrMatch objectToStruct(PropFuncArg argObject, boolean executionTime) {
        ArrayList<Resource> props = new ArrayList<Resource>();
        if (argObject.isNode()) {
            Node o = argObject.getArg();
            if (!o.isLiteral()) {
                if (executionTime) {
                    log.warn("Object to text:query is not a literal " + String.valueOf(argObject));
                }
                return null;
            }
            String lang = o.getLiteralLanguage();
            RDFDatatype dt = o.getLiteralDatatype();
            if (lang.isEmpty()) {
                if (dt != null && dt != XSDDatatype.XSDstring) {
                    log.warn("Object to text query is not a string");
                    return null;
                }
                lang = null;
            }
            String qs = o.getLiteralLexicalForm();
            return new StrMatch(props, qs, lang, -1, 0.0f, null);
        }
        List list = argObject.getArgList();
        if (list.size() == 0) {
            throw new TextIndexException("text:query object list can not be empty");
        }
        int idx = 0;
        Node x = (Node)list.get(idx);
        while (x.isURI()) {
            Property prop = ResourceFactory.createProperty((String)x.getURI());
            log.trace("objectToStruct: x.isURI(), prop: " + String.valueOf(prop) + " at idx: " + idx);
            List<Resource> pList = Util.getPropList((Resource)prop);
            log.trace("objectToStruct: PROPERTY at " + idx + " IS " + String.valueOf(prop) + " WITH pList: " + String.valueOf(pList));
            if (pList != null) {
                props.addAll(pList);
            } else {
                props.add((Resource)prop);
            }
            if (++idx >= list.size()) {
                throw new TextIndexException("List of properties specified but no query string : " + String.valueOf(list));
            }
            if (!this.isIndexed(props)) {
                log.warn("objectToStruct: props are not indexed " + String.valueOf(props));
                return null;
            }
            x = (Node)list.get(idx);
        }
        if (!x.isLiteral()) {
            if (executionTime) {
                log.warn("Text query string is not a literal " + String.valueOf(list) + " AT idx: " + idx);
            }
            return null;
        }
        String lang = x.getLiteralLanguage();
        if (lang.isEmpty()) {
            if (x.getLiteralDatatype() != null && !x.getLiteralDatatype().equals(XSDDatatype.XSDstring)) {
                log.warn("Text query is not a string " + String.valueOf(list));
                return null;
            }
            lang = null;
        }
        String queryString = x.getLiteralLexicalForm();
        int limit = -1;
        float score = 0.0f;
        if (++idx < list.size()) {
            x = (Node)list.get(idx);
            ++idx;
            if (!x.isLiteral()) {
                if (executionTime) {
                    log.warn("Text query limit is not an integer " + String.valueOf(x));
                }
                return null;
            }
            int v = NodeFactoryExtra.nodeToInt((Node)x);
            limit = v < 0 ? -1 : v;
        }
        String string = lang = lang == null ? this.extractArg("lang", list) : lang;
        if (lang != null && this.textIndex.getDocDef().getLangField() == null) {
            log.warn("lang argument is ignored if langField not set in the index configuration");
        }
        String highlight = this.extractArg("highlight", list);
        return new StrMatch(props, queryString, lang, limit, score, highlight);
    }

    class StrMatch {
        private final List<Resource> props;
        private final String queryString;
        private final String lang;
        private final int limit;
        private int queryLimit;
        private final float scoreLimit;
        private final String highlight;

        public StrMatch(List<Resource> props, String queryString, String lang, int limit, float scoreLimit, String highlight) {
            this.props = props;
            this.queryString = queryString;
            this.lang = lang;
            this.limit = limit;
            this.queryLimit = limit;
            this.scoreLimit = scoreLimit;
            this.highlight = highlight;
        }

        public List<Resource> getProps() {
            return this.props;
        }

        public boolean hasProps() {
            return this.props.size() > 0;
        }

        public String getQueryString() {
            return this.queryString;
        }

        public String getLang() {
            return this.lang;
        }

        public int getLimit() {
            return this.limit;
        }

        public void setQueryLimit(int qLimit) {
            this.queryLimit = qLimit;
        }

        public int getQueryLimit() {
            return this.queryLimit;
        }

        public float getScoreLimit() {
            return this.scoreLimit;
        }

        public String getHighlight() {
            return this.highlight;
        }

        public String toString() {
            return "( properties: " + String.valueOf(this.props) + "; query: " + this.queryString + "; limit: " + this.limit + "; lang: " + this.lang + "; highlight: " + this.highlight + " )";
        }
    }
}

