/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.jena.datatypes.RDFDatatype;

public class Entity {
    private final String id;
    private final String graph;
    private final String language;
    private final RDFDatatype datatype;
    private final Map<String, Object> map = new HashMap<String, Object>();

    public Entity(String entityId, String entityGraph) {
        this(entityId, entityGraph, null, null);
    }

    public Entity(String entityId, String entityGraph, String lang, RDFDatatype datatype) {
        this.id = entityId;
        this.graph = entityGraph;
        this.language = lang;
        this.datatype = datatype;
    }

    @Deprecated
    public Entity(String entityId) {
        this(entityId, null);
    }

    public String getId() {
        return this.id;
    }

    public String getGraph() {
        return this.graph;
    }

    public String getLanguage() {
        return this.language;
    }

    public RDFDatatype getDatatype() {
        return this.datatype;
    }

    public void put(String key, Object value) {
        this.map.put(key, value);
    }

    public Object get(String key) {
        return this.map.get(key);
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public String getChecksum(String property, String value) {
        String key = this.getGraph() + "-" + this.getId() + "-" + property + "-" + value + "-" + this.getLanguage();
        return DigestUtils.sha256Hex((String)key);
    }

    public String toString() {
        return this.id + " : " + String.valueOf(this.map);
    }

    public String toStringDetail() {
        return this.id + " : " + this.graph + " : " + this.language + " : " + String.valueOf(this.datatype) + " : " + String.valueOf(this.map);
    }
}

