/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.assembler.AssemblerUtils;
import com.hp.hpl.jena.sparql.util.Context;
import org.apache.jena.query.text.DatasetGraphText;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextDocProducerTriples;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexLucene;
import org.apache.jena.query.text.TextIndexSolr;
import org.apache.jena.query.text.TextQuery;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.lucene.store.Directory;
import org.apache.solr.client.solrj.SolrServer;

public class TextDatasetFactory {
    public static Dataset create(String assemblerFile) {
        return (Dataset)AssemblerUtils.build((String)assemblerFile, (Resource)TextVocab.textDataset);
    }

    public static Dataset create(Dataset base, TextIndex textIndex) {
        DatasetGraph dsg = base.asDatasetGraph();
        dsg = TextDatasetFactory.create(dsg, textIndex);
        return DatasetFactory.create((DatasetGraph)dsg);
    }

    public static DatasetGraph create(DatasetGraph dsg, TextIndex textIndex) {
        TextDocProducerTriples producer = new TextDocProducerTriples(textIndex.getDocDef(), textIndex);
        DatasetGraphText dsgt = new DatasetGraphText(dsg, textIndex, producer);
        Context c = dsgt.getContext();
        dsgt.getContext().set(TextQuery.textIndex, (Object)textIndex);
        return dsgt;
    }

    public static TextIndex createLuceneIndex(Directory directory, EntityDefinition entMap) {
        TextIndexLucene index = new TextIndexLucene(directory, entMap);
        return index;
    }

    public static Dataset createLucene(Dataset base, Directory directory, EntityDefinition entMap) {
        TextIndex index = TextDatasetFactory.createLuceneIndex(directory, entMap);
        return TextDatasetFactory.create(base, index);
    }

    public static DatasetGraph createLucene(DatasetGraph base, Directory directory, EntityDefinition entMap) {
        TextIndex index = TextDatasetFactory.createLuceneIndex(directory, entMap);
        return TextDatasetFactory.create(base, index);
    }

    public static TextIndex createSolrIndex(SolrServer server, EntityDefinition entMap) {
        TextIndexSolr index = new TextIndexSolr(server, entMap);
        return index;
    }

    public static Dataset createSolrIndex(Dataset base, SolrServer server, EntityDefinition entMap) {
        TextIndex index = TextDatasetFactory.createSolrIndex(server, entMap);
        return TextDatasetFactory.create(base, index);
    }

    public static DatasetGraph createSolrIndex(DatasetGraph base, SolrServer server, EntityDefinition entMap) {
        TextIndex index = TextDatasetFactory.createSolrIndex(server, entMap);
        return TextDatasetFactory.create(base, index);
    }

    static {
        TextQuery.init();
    }
}

