/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.slice.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.NavigableSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.jena.sparql.service.enhancer.claimingcache.AsyncClaimingCache;
import org.apache.jena.sparql.service.enhancer.claimingcache.AsyncClaimingCacheImplGuava;
import org.apache.jena.sparql.service.enhancer.claimingcache.RefFuture;
import org.apache.jena.sparql.service.enhancer.impl.util.LockUtils;
import org.apache.jena.sparql.service.enhancer.impl.util.PageUtils;
import org.apache.jena.sparql.service.enhancer.slice.api.ArrayOps;
import org.apache.jena.sparql.service.enhancer.slice.api.Disposable;
import org.apache.jena.sparql.service.enhancer.slice.api.Slice;
import org.apache.jena.sparql.service.enhancer.slice.api.SliceMetaDataBasic;
import org.apache.jena.sparql.service.enhancer.slice.api.SliceWithPages;
import org.apache.jena.sparql.service.enhancer.slice.impl.BufferOverArray;
import org.apache.jena.sparql.service.enhancer.slice.impl.BufferView;
import org.apache.jena.sparql.service.enhancer.slice.impl.RangeBuffer;
import org.apache.jena.sparql.service.enhancer.slice.impl.RangeBufferImpl;
import org.apache.jena.sparql.service.enhancer.slice.impl.SliceBase;
import org.apache.jena.sparql.service.enhancer.slice.impl.SliceMetaDataWithPages;
import org.apache.jena.sparql.service.enhancer.slice.impl.SliceMetaDataWithPagesImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceInMemoryCache<A>
extends SliceBase<A>
implements SliceWithPages<A> {
    private static final Logger logger = LoggerFactory.getLogger(SliceInMemoryCache.class);
    protected SliceMetaDataWithPages metaData;
    protected AsyncClaimingCache<Long, BufferView<A>> pageCache;

    protected SliceInMemoryCache(ArrayOps<A> arrayOps, int pageSize, AsyncClaimingCacheImplGuava.Builder<Long, BufferView<A>> cacheBuilder) {
        super(arrayOps);
        this.metaData = new SliceMetaDataWithPagesImpl(pageSize);
        this.pageCache = cacheBuilder.setCacheLoader(this::loadPage).setAtomicRemovalListener((RemovalListener<Long, BufferView>)((RemovalListener)n -> this.evictPage((Long)n.getKey()))).build();
    }

    public static <A> Slice<A> create(ArrayOps<A> arrayOps, int pageSize, int maxCachedPages) {
        AsyncClaimingCacheImplGuava.Builder<Long, BufferView<A>> cacheBuilder = AsyncClaimingCacheImplGuava.newBuilder((CacheBuilder<Object, Object>)CacheBuilder.newBuilder().maximumSize((long)maxCachedPages));
        return new SliceInMemoryCache<A>(arrayOps, pageSize, cacheBuilder);
    }

    protected void evictPage(long pageId) {
        long pageOffset = this.getPageOffsetForPageId(pageId);
        int pageSize = this.metaData.getPageSize();
        Range pageRange = Range.closedOpen((Comparable)Long.valueOf(pageOffset), (Comparable)Long.valueOf(pageOffset + (long)pageSize));
        if (logger.isDebugEnabled()) {
            logger.debug("Attempting to evict page " + pageId + " with range " + String.valueOf(pageRange));
        }
        LockUtils.runWithLock(this.readWriteLock.writeLock(), () -> this.metaData.getLoadedRanges().remove(pageRange));
        if (logger.isDebugEnabled()) {
            logger.debug("Evicted page " + pageId + " with range " + String.valueOf(pageRange));
        }
    }

    protected BufferView<A> loadPage(long pageId) {
        long pageOffset = this.getPageOffsetForPageId(pageId);
        BufferOverArray<int> buffer = BufferOverArray.create(this.arrayOps, this.metaData.getPageSize());
        final RangeBufferImpl<int> rangeBuffer = RangeBufferImpl.create(this.metaData.getLoadedRanges(), pageOffset, buffer);
        BufferView result = new BufferView<A>(){

            @Override
            public RangeBuffer<A> getRangeBuffer() {
                return rangeBuffer;
            }

            @Override
            public long getGeneration() {
                return 0L;
            }

            @Override
            public ReadWriteLock getReadWriteLock() {
                return SliceInMemoryCache.this.readWriteLock;
            }
        };
        return result;
    }

    @Override
    protected SliceMetaDataBasic getMetaData() {
        return this.metaData;
    }

    public void sync() {
    }

    @Override
    public long getPageSize() {
        return this.metaData.getPageSize();
    }

    @Override
    public RefFuture<BufferView<A>> getPageForPageId(long pageId) {
        return this.pageCache.claim(pageId);
    }

    @Override
    public Disposable addEvictionGuard(RangeSet<Long> ranges) {
        long pageSize = this.getPageSize();
        NavigableSet<Long> pageIds = PageUtils.touchedPageIndices(ranges.asRanges(), pageSize);
        if (logger.isDebugEnabled()) {
            logger.debug("Added eviction guard over ranges " + String.valueOf(ranges) + " affecting page ids " + String.valueOf(pageIds));
        }
        Disposable core = this.pageCache.addEvictionGuard((? super K key) -> pageIds.contains(key));
        return () -> {
            if (logger.isDebugEnabled()) {
                logger.debug("Removed eviction guard over ranges " + String.valueOf(ranges) + " affecting page ids " + String.valueOf(pageIds));
            }
            core.close();
        };
    }

    @Override
    public void clear() {
        ReadWriteLock rwl = this.getReadWriteLock();
        Lock writeLock = rwl.writeLock();
        writeLock.lock();
        try {
            this.pageCache.invalidateAll();
            this.setMinimumKnownSize(0L);
            this.setMaximumKnownSize(Long.MAX_VALUE);
            this.getFailedRanges().clear();
            this.getLoadedRanges().clear();
        }
        finally {
            writeLock.unlock();
        }
    }
}

