/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.slice.impl;

import com.google.common.collect.RangeMap;
import com.google.common.collect.RangeSet;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jena.sparql.service.enhancer.slice.api.ArrayOps;
import org.apache.jena.sparql.service.enhancer.slice.api.Slice;
import org.apache.jena.sparql.service.enhancer.slice.api.SliceMetaDataBasic;

public abstract class SliceBase<A>
implements Slice<A> {
    protected ArrayOps<A> arrayOps;
    protected ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    protected Condition hasDataCondition = this.readWriteLock.writeLock().newCondition();

    public SliceBase(ArrayOps<A> arrayOps) {
        this.arrayOps = arrayOps;
    }

    protected abstract SliceMetaDataBasic getMetaData();

    @Override
    public RangeSet<Long> getLoadedRanges() {
        return this.getMetaData().getLoadedRanges();
    }

    @Override
    public RangeMap<Long, List<Throwable>> getFailedRanges() {
        return this.getMetaData().getFailedRanges();
    }

    @Override
    public long getMinimumKnownSize() {
        return this.getMetaData().getMinimumKnownSize();
    }

    @Override
    public void setMinimumKnownSize(long size) {
        this.getMetaData().setMinimumKnownSize(size);
    }

    @Override
    public long getMaximumKnownSize() {
        return this.getMetaData().getMaximumKnownSize();
    }

    @Override
    public void setMaximumKnownSize(long size) {
        this.getMetaData().setMaximumKnownSize(size);
    }

    @Override
    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    @Override
    public Condition getHasDataCondition() {
        return this.hasDataCondition;
    }

    @Override
    public ArrayOps<A> getArrayOps() {
        return this.arrayOps;
    }
}

