/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.slice.impl;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.io.IOException;
import org.apache.jena.sparql.service.enhancer.slice.impl.Buffer;
import org.apache.jena.sparql.service.enhancer.slice.impl.BufferLike;

public interface RangeBuffer<A>
extends BufferLike<A> {
    public RangeSet<Long> getRanges();

    public Long getOffsetInRanges();

    public Buffer<A> getBackingBuffer();

    public RangeSet<Long> getCoveredRanges(Range<Long> var1);

    default public void transferFrom(long thisOffset, RangeBuffer<A> other, long otherOffset, long length) throws IOException {
        RangeBuffer.transfer(other, otherOffset, this, thisOffset, length);
    }

    default public void transferTo(long thisOffset, RangeBuffer<A> other, long otherOffset, long length) throws IOException {
        RangeBuffer.transfer(this, thisOffset, other, otherOffset, length);
    }

    public static <A> void transfer(RangeBuffer<A> src, long srcOffset, RangeBuffer<A> tgt, long tgtOffset, long length) throws IOException {
        Range readRange = Range.closedOpen((Comparable)Long.valueOf(srcOffset), (Comparable)Long.valueOf(srcOffset + length));
        RangeSet<Long> validReadRanges = src.getCoveredRanges((Range<Long>)readRange);
        int n = 4096;
        Object buffer = tgt.getArrayOps().create(n);
        for (Range range : validReadRanges.asRanges()) {
            ContiguousSet cs = ContiguousSet.create((Range)range, (DiscreteDomain)DiscreteDomain.longs());
            int remaining = cs.size();
            long first = (Long)cs.first();
            while (remaining > 0) {
                int x = Math.min(remaining, n);
                src.readInto(buffer, 0, first, x);
                long o = srcOffset - tgtOffset + first;
                tgt.write(o, buffer, 0, x);
                remaining -= x;
                first += (long)x;
            }
        }
    }
}

