/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.slice.impl;

import org.apache.jena.sparql.service.enhancer.slice.api.ArrayOps;
import org.apache.jena.sparql.service.enhancer.slice.impl.Buffer;

public class BufferOverArray<A>
implements Buffer<A> {
    protected ArrayOps<A> arrayOps;
    protected A array;

    public BufferOverArray(ArrayOps<A> arrayOps, int size) {
        this(arrayOps, arrayOps.create(size));
    }

    public BufferOverArray(ArrayOps<A> arrayOps, A array) {
        this.arrayOps = arrayOps;
        this.array = array;
    }

    public static <A> BufferOverArray<A> create(ArrayOps<A> arrayOps, int size) {
        return new BufferOverArray<int>((ArrayOps<int>)arrayOps, size);
    }

    public static <A> BufferOverArray<A> create(ArrayOps<A> arrayOps, A array) {
        return new BufferOverArray<A>(arrayOps, array);
    }

    @Override
    public void write(long offsetInBuffer, A arrayWithItemsOfTypeT, int arrOffset, int arrLength) {
        int offsetInBufferInt = Math.toIntExact(offsetInBuffer);
        this.arrayOps.copy(arrayWithItemsOfTypeT, arrOffset, this.array, offsetInBufferInt, arrLength);
    }

    @Override
    public long getCapacity() {
        return this.arrayOps.length(this.array);
    }

    @Override
    public ArrayOps<A> getArrayOps() {
        return this.arrayOps;
    }

    @Override
    public int readInto(A tgt, int tgtOffset, long srcOffset, int length) {
        int capacityInt = this.arrayOps.length(this.array);
        int srcOffsetInt = Math.toIntExact(srcOffset);
        int result = Math.max(Math.min(capacityInt - srcOffsetInt, length), 0);
        this.arrayOps.copy(this.array, srcOffsetInt, tgt, tgtOffset, result);
        if (result == 0 && length > 0) {
            result = -1;
        }
        return result;
    }

    @Override
    public void put(long offset, Object item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object get(long index) {
        throw new UnsupportedOperationException();
    }
}

