/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.slice.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.List;
import org.apache.jena.sparql.service.enhancer.impl.util.RangeUtils;

public interface SliceMetaDataBasic {
    public RangeSet<Long> getLoadedRanges();

    public RangeMap<Long, List<Throwable>> getFailedRanges();

    public long getMinimumKnownSize();

    public void setMinimumKnownSize(long var1);

    public long getMaximumKnownSize();

    public void setMaximumKnownSize(long var1);

    default public SliceMetaDataBasic updateMaximumKnownSize(long size) {
        long current = this.getMaximumKnownSize();
        if (size < current) {
            this.setMaximumKnownSize(size);
        }
        return this;
    }

    default public SliceMetaDataBasic updateMinimumKnownSize(long size) {
        long current = this.getMinimumKnownSize();
        if (size > current) {
            this.setMinimumKnownSize(size);
        }
        return this;
    }

    default public long getKnownSize() {
        long maxSize;
        long minSize = this.getMinimumKnownSize();
        return minSize == (maxSize = this.getMaximumKnownSize()) ? minSize : -1L;
    }

    default public SliceMetaDataBasic setKnownSize(long size) {
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"Negative known size");
        this.setMinimumKnownSize(size);
        this.setMaximumKnownSize(size);
        return this;
    }

    default public RangeSet<Long> getGaps(Range<Long> requestRange) {
        RangeSet<Long> result;
        long maxKnownSize = this.getMaximumKnownSize();
        Range maxKnownRange = Range.closedOpen((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(maxKnownSize));
        boolean isConnected = requestRange.isConnected(maxKnownRange);
        if (isConnected) {
            Range effectiveRequestRange = requestRange.intersection(maxKnownRange);
            RangeSet<Long> loadedRanges = this.getLoadedRanges();
            result = RangeUtils.gaps(effectiveRequestRange, loadedRanges);
        } else {
            result = TreeRangeSet.create();
        }
        return result;
    }
}

