/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.slice.api;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.sparql.service.enhancer.slice.api.Disposable;
import org.apache.jena.sparql.service.enhancer.slice.api.HasArrayOps;
import org.apache.jena.sparql.service.enhancer.slice.api.SliceAccessor;
import org.apache.jena.sparql.service.enhancer.slice.api.SliceMetaDataBasic;

public interface Slice<T>
extends SliceMetaDataBasic,
HasArrayOps<T>,
Sync {
    public ReadWriteLock getReadWriteLock();

    public Condition getHasDataCondition();

    public Disposable addEvictionGuard(RangeSet<Long> var1);

    default public boolean isComplete() {
        boolean result = this.computeFromMetaData(false, metaData -> {
            long knownSize = metaData.getKnownSize();
            Set ranges = metaData.getLoadedRanges().asRanges();
            Range range = ranges.size() == 1 ? (Range)ranges.iterator().next() : null;
            long endpoint = range != null ? (Long)range.upperEndpoint() : -1L;
            boolean r = endpoint >= 0L && knownSize == endpoint;
            return r;
        });
        return result;
    }

    default public void mutateMetaData(Consumer<? super SliceMetaDataBasic> fn) {
        this.computeFromMetaData(true, metaData -> {
            fn.accept((SliceMetaDataBasic)metaData);
            return null;
        });
    }

    default public void readMetaData(Consumer<? super SliceMetaDataBasic> fn) {
        this.computeFromMetaData(false, metaData -> {
            fn.accept((SliceMetaDataBasic)metaData);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <X> X computeFromMetaData(boolean isWrite, Function<? super SliceMetaDataBasic, X> fn) {
        X result;
        ReadWriteLock rwl = this.getReadWriteLock();
        Lock lock = isWrite ? rwl.writeLock() : rwl.readLock();
        lock.lock();
        try {
            result = fn.apply(this);
            if (isWrite) {
                this.getHasDataCondition().signalAll();
            }
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    public SliceAccessor<T> newSliceAccessor();

    public void clear();
}

