/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.slice.api;

import com.google.common.primitives.Ints;
import java.io.IOException;
import org.apache.jena.sparql.service.enhancer.slice.api.ArrayOps;
import org.apache.jena.sparql.service.enhancer.slice.api.ReadableChannel;

public class ReadableChannelWithLimit<A>
implements ReadableChannel<A> {
    protected ReadableChannel<A> delegate;
    protected long limit;
    protected long remaining;

    public ReadableChannelWithLimit(ReadableChannel<A> backend, long limit) {
        this.delegate = backend;
        this.limit = limit;
        this.remaining = limit;
    }

    public ReadableChannel<A> getDelegate() {
        return this.delegate;
    }

    @Override
    public ArrayOps<A> getArrayOps() {
        return this.getDelegate().getArrayOps();
    }

    @Override
    public void close() throws IOException {
        this.getDelegate().close();
    }

    @Override
    public boolean isOpen() {
        return this.getDelegate().isOpen();
    }

    @Override
    public int read(A array, int position, int length) throws IOException {
        int result;
        if (this.remaining <= 0L) {
            result = -1;
        } else {
            int n = Math.min(Ints.saturatedCast((long)this.remaining), length);
            result = this.getDelegate().read(array, position, n);
            if (result > 0) {
                this.remaining -= (long)result;
            }
        }
        return result;
    }
}

