/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.slice.api;

import java.io.IOException;
import org.apache.jena.sparql.service.enhancer.slice.api.ArrayOps;
import org.apache.jena.sparql.service.enhancer.slice.api.ReadableChannelBase;
import org.apache.jena.sparql.service.enhancer.slice.api.SliceAccessor;

public class ReadableChannelOverSliceAccessor<A>
extends ReadableChannelBase<A> {
    protected SliceAccessor<A> accessor;
    protected long posInSlice;

    public ReadableChannelOverSliceAccessor(SliceAccessor<A> accessor, long posInSlice) {
        this.accessor = accessor;
        this.posInSlice = posInSlice;
    }

    @Override
    public ArrayOps<A> getArrayOps() {
        return this.accessor.getSlice().getArrayOps();
    }

    @Override
    public void closeActual() throws IOException {
        this.accessor.close();
    }

    @Override
    public int read(A array, int position, int length) throws IOException {
        this.accessor.claimByOffsetRange(this.posInSlice, this.posInSlice + (long)length);
        int result = this.accessor.unsafeRead(array, position, this.posInSlice, length);
        if (result > 0) {
            this.posInSlice += (long)result;
        }
        return result;
    }
}

