/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.slice.api;

public interface PageHelper {
    public long getPageSize();

    default public long getPageOffsetForPageId(long pageId) {
        long pageSize = this.getPageSize();
        return PageHelper.getPageOffsetForPageId(pageId, pageSize);
    }

    default public long getPageIdForOffset(long offset) {
        long pageSize = this.getPageSize();
        return PageHelper.getPageIdForOffset(offset, pageSize);
    }

    default public long getIndexInPageForOffset(long offset) {
        long pageSize = this.getPageSize();
        return PageHelper.getIndexInPageForOffset(offset, pageSize);
    }

    public static long getPageIdForOffset(long offset, long pageSize) {
        long result = offset / pageSize;
        return result;
    }

    public static long getIndexInPageForOffset(long offset, long pageSize) {
        return offset % pageSize;
    }

    public static long getPageOffsetForPageId(long pageId, long pageSize) {
        return pageId * pageSize;
    }

    public static long getLastPageId(long size, long pageSize) {
        return size / pageSize;
    }
}

