/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.slice.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import org.apache.jena.atlas.iterator.IteratorCloseable;
import org.apache.jena.sparql.service.enhancer.slice.api.ArrayOps;
import org.apache.jena.sparql.service.enhancer.slice.api.ReadableChannel;

public class IteratorOverReadableChannel<T>
extends AbstractIterator<T>
implements IteratorCloseable<T> {
    protected ReadableChannel<T[]> dataStream;
    protected ArrayOps<T[]> arrayOps;
    protected Object array;
    protected int arrayLength;
    protected int currentOffset;
    protected int currentDataLength;

    public IteratorOverReadableChannel(ArrayOps<T[]> arrayOps, ReadableChannel<T[]> dataStream, int internalBufferSize) {
        Preconditions.checkArgument((internalBufferSize >= 0 ? 1 : 0) != 0, (Object)"Internal buffer size must be greater than 0");
        this.arrayOps = arrayOps;
        this.dataStream = dataStream;
        this.arrayLength = internalBufferSize;
        this.array = arrayOps.create(internalBufferSize);
        this.currentDataLength = 0;
        this.currentOffset = 0;
    }

    protected T computeNext() {
        Object tmp;
        if (this.currentOffset >= this.currentDataLength) {
            try {
                this.currentDataLength = this.dataStream.readRaw(this.array, 0, this.arrayLength);
                this.currentOffset = 0;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.currentDataLength == -1) {
            tmp = this.endOfData();
        } else {
            tmp = this.arrayOps.getRaw(this.array, this.currentOffset);
            if (tmp == null) {
                throw new NullPointerException("Unexpected null value");
            }
        }
        ++this.currentOffset;
        Object result = tmp;
        return (T)result;
    }

    public void close() {
        try {
            this.dataStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

