/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.slice.api;

import java.lang.reflect.Array;
import java.util.function.IntFunction;
import org.apache.jena.sparql.service.enhancer.slice.impl.ArrayOpsObject;

public interface ArrayOps<A> {
    public static final ArrayOpsObject<Object> OBJECT = ArrayOps.createFor(Object.class);

    public A create(int var1);

    public Object get(A var1, int var2);

    public void set(A var1, int var2, Object var3);

    public int length(A var1);

    public void fill(A var1, int var2, int var3, Object var4);

    public void copy(A var1, int var2, A var3, int var4, int var5);

    public Object getDefaultValue();

    default public void fillRaw(Object array, int offset, int length, Object value) {
        this.fill(array, offset, length, value);
    }

    default public void copyRaw(Object src, int srcPos, Object dest, int destPos, int length) {
        this.copy(src, srcPos, dest, destPos, length);
    }

    default public Object getRaw(Object array, int index) {
        return this.get(array, index);
    }

    default public void setRaw(Object array, int index, Object value) {
        this.set(array, index, value);
    }

    default public void lengthRaw(Object array) {
        this.length(array);
    }

    public static <T> ArrayOpsObject<T> createFor(Class<T> componentType) {
        return new ArrayOpsObject(size -> (Object[])Array.newInstance(componentType, size));
    }

    public static <T> ArrayOpsObject<T> createFor(IntFunction<T[]> arrayConstructor) {
        return new ArrayOpsObject(arrayConstructor);
    }
}

