/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.pfunction;

import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.Rename;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropFuncArgType;
import org.apache.jena.sparql.pfunction.PropertyFunctionEval;
import org.apache.jena.sparql.service.enhancer.claimingcache.RefFuture;
import org.apache.jena.sparql.service.enhancer.impl.ServiceCacheKey;
import org.apache.jena.sparql.service.enhancer.impl.ServiceCacheValue;
import org.apache.jena.sparql.service.enhancer.impl.ServiceResponseCache;
import org.apache.jena.sparql.service.enhancer.impl.util.PropFuncArgUtils;
import org.apache.jena.sparql.service.enhancer.init.ServiceEnhancerConstants;
import org.apache.jena.sparql.service.enhancer.slice.api.Slice;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.NodeFactoryExtra;

public class cacheLs
extends PropertyFunctionEval {
    public static final String DEFAULT_IRI = "http://jena.apache.org/service-enhancer#cacheLs";

    public cacheLs() {
        super(PropFuncArgType.PF_ARG_SINGLE, PropFuncArgType.PF_ARG_EITHER);
    }

    private static Optional<BindingBuilder> processArg(Optional<BindingBuilder> builderOpt, List<Node> nodes, int i, Supplier<Node> valueSupplier) {
        Optional<Object> result = builderOpt;
        if (builderOpt.isPresent()) {
            BindingBuilder builder = builderOpt.orElseThrow();
            int n = nodes.size();
            if (i < n) {
                Node key = nodes.get(i);
                Node value = valueSupplier.get();
                if (key.isVariable()) {
                    builder.add((Var)key, value);
                } else if (!Objects.equals(key, value)) {
                    result = Optional.empty();
                }
            }
        }
        return result;
    }

    public QueryIterator execEvaluated(Binding inputBinding, PropFuncArg subject, Node predicate, PropFuncArg object, ExecutionContext execCxt) {
        NodeValue snv;
        Context context = execCxt.getContext();
        ServiceResponseCache cache = (ServiceResponseCache)context.get(ServiceEnhancerConstants.serviceCache);
        Node s = subject.getArg();
        Var sv = s instanceof Var ? (Var)s : null;
        Set<Long> subset = null;
        if (sv == null && (snv = NodeValue.makeNode((Node)s)).isInteger()) {
            long v = snv.getInteger().longValue();
            subset = Collections.singleton(v);
        }
        List<Node> objectArgs = PropFuncArgUtils.getAsList(object);
        Map<Long, ServiceCacheKey> idToKey = cache.getIdToKey();
        Sets.SetView baseIds = idToKey.keySet();
        Sets.SetView ids = subset == null ? baseIds : Sets.intersection(subset, baseIds);
        Iterator it = ids.stream().flatMap(id -> {
            Node idNode = NodeValue.makeInteger((long)id).asNode();
            Optional<BindingBuilder> parentBuilder = Optional.of(BindingFactory.builder((Binding)inputBinding));
            if (sv != null) {
                parentBuilder.orElseThrow().add(sv, idNode);
            }
            ServiceCacheKey key = (ServiceCacheKey)idToKey.get(id);
            parentBuilder = cacheLs.processArg(parentBuilder, objectArgs, 0, () -> key.getServiceNode());
            parentBuilder = cacheLs.processArg(parentBuilder, objectArgs, 1, () -> {
                Op normOp = key.getOp();
                Op op = Rename.reverseVarRename((Op)normOp, (boolean)true);
                Query query = OpAsQuery.asQuery((Op)op);
                return NodeFactory.createLiteralString((String)query.toString());
            });
            parentBuilder = cacheLs.processArg(parentBuilder, objectArgs, 2, () -> NodeFactory.createLiteralString((String)key.getBinding().toString()));
            Optional<Binding> parentBindingOpt = parentBuilder.map(BindingBuilder::build);
            Stream<Object> r = parentBindingOpt.stream();
            if (objectArgs.size() > 3) {
                r = r.flatMap(parentBinding -> {
                    List<Object> ranges;
                    block12: {
                        try (RefFuture<ServiceCacheValue> refFuture = cache.getCache().claimIfPresent(key);){
                            if (refFuture != null) {
                                ServiceCacheValue entry = refFuture.await();
                                Slice<Binding[]> slice = entry.getSlice();
                                Lock lock = slice.getReadWriteLock().readLock();
                                lock.lock();
                                try {
                                    ranges = new ArrayList(entry.getSlice().getLoadedRanges().asRanges());
                                }
                                finally {
                                    lock.unlock();
                                }
                                if (ranges.isEmpty()) {
                                    ranges = Collections.singletonList(Range.closedOpen((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(0L)));
                                }
                                break block12;
                            }
                            ranges = Collections.emptyList();
                        }
                    }
                    return ranges.stream().flatMap(range -> {
                        Optional<BindingBuilder> bb = Optional.of(BindingBuilder.create((Binding)parentBinding));
                        if (range.hasLowerBound()) {
                            bb = cacheLs.processArg(bb, objectArgs, 3, () -> NodeFactoryExtra.intToNode((long)((Long)range.lowerEndpoint())));
                        }
                        if (range.hasUpperBound()) {
                            bb = cacheLs.processArg(bb, objectArgs, 4, () -> NodeFactoryExtra.intToNode((long)((Long)range.upperEndpoint())));
                        }
                        return bb.map(BindingBuilder::build).stream();
                    });
                });
            }
            return r;
        }).iterator();
        return QueryIterPlainWrapper.create(it, (ExecutionContext)execCxt);
    }
}

