/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.init;

import com.google.common.collect.BiMap;
import java.util.Map;
import java.util.Set;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.assemblers.AssemblerGroup;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.optimize.Optimize;
import org.apache.jena.sparql.algebra.optimize.Rewrite;
import org.apache.jena.sparql.algebra.optimize.RewriteFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DynamicDatasets;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.apache.jena.sparql.core.assembler.DatasetAssembler;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.Rename;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.engine.iterator.QueryIterCommonParent;
import org.apache.jena.sparql.engine.iterator.QueryIteratorMapped;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.pfunction.PropertyFunctionRegistry;
import org.apache.jena.sparql.service.ServiceExecutorRegistry;
import org.apache.jena.sparql.service.bulk.ChainingServiceExecutorBulk;
import org.apache.jena.sparql.service.enhancer.algebra.TransformSE_EffectiveOptions;
import org.apache.jena.sparql.service.enhancer.algebra.TransformSE_JoinStrategy;
import org.apache.jena.sparql.service.enhancer.assembler.DatasetAssemblerServiceEnhancer;
import org.apache.jena.sparql.service.enhancer.assembler.ServiceEnhancerVocab;
import org.apache.jena.sparql.service.enhancer.function.cacheRm;
import org.apache.jena.sparql.service.enhancer.impl.ChainingServiceExecutorBulkServiceEnhancer;
import org.apache.jena.sparql.service.enhancer.impl.ServiceOpts;
import org.apache.jena.sparql.service.enhancer.impl.ServiceResponseCache;
import org.apache.jena.sparql.service.enhancer.impl.ServiceResultSizeCache;
import org.apache.jena.sparql.service.enhancer.impl.util.DynamicDatasetUtils;
import org.apache.jena.sparql.service.enhancer.impl.util.VarScopeUtils;
import org.apache.jena.sparql.service.enhancer.init.ServiceEnhancerConstants;
import org.apache.jena.sparql.service.enhancer.pfunction.cacheLs;
import org.apache.jena.sparql.service.single.ChainingServiceExecutor;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sys.JenaSubsystemLifecycle;

public class ServiceEnhancerInit
implements JenaSubsystemLifecycle {
    public void start() {
        ServiceEnhancerInit.init();
    }

    public void stop() {
    }

    public static void init() {
        ServiceResponseCache cache = new ServiceResponseCache();
        ARQ.getContext().put(ServiceEnhancerConstants.serviceCache, (Object)cache);
        ServiceResultSizeCache resultSizeCache = new ServiceResultSizeCache();
        ServiceResultSizeCache.set(ARQ.getContext(), resultSizeCache);
        ServiceExecutorRegistry.get().addBulkLink((ChainingServiceExecutorBulk)new ChainingServiceExecutorBulkServiceEnhancer());
        ServiceEnhancerInit.registerServiceExecutorSelf(ServiceExecutorRegistry.get());
        ServiceEnhancerInit.registerWith(Assembler.general());
        ServiceEnhancerInit.registerFunctions(FunctionRegistry.get());
        ServiceEnhancerInit.registerPFunctions(PropertyFunctionRegistry.get());
    }

    public static void registerFunctions(FunctionRegistry reg) {
        reg.put("http://jena.apache.org/service-enhancer#cacheRm", cacheRm.class);
    }

    public static void registerPFunctions(PropertyFunctionRegistry reg) {
        reg.put("http://jena.apache.org/service-enhancer#cacheLs", cacheLs.class);
    }

    public static void registerServiceExecutorSelf(ServiceExecutorRegistry registry) {
        ChainingServiceExecutor selfExec = (opExec, opOrig, binding, execCxt, chain) -> {
            QueryIterator r;
            ServiceOpts so = ServiceOpts.getEffectiveService(opExec);
            OpService target = so.getTargetService();
            DatasetGraph dataset = execCxt.getDataset();
            if (ServiceEnhancerConstants.SELF.equals((Object)target.getService())) {
                String optimizerMode = so.getFirstValue("optimize", "on", "on");
                Op op = opExec.getSubOp();
                boolean useQc = false;
                if (useQc) {
                    if (!"off".equals(optimizerMode)) {
                        Context cxt = execCxt.getContext();
                        RewriteFactory rf = ServiceEnhancerInit.decideOptimizer(cxt);
                        Rewrite rw = rf.create(cxt);
                        op = rw.rewrite(op);
                    }
                    r = QC.execute((Op)op, (Binding)binding, (ExecutionContext)execCxt);
                } else {
                    Context cxtCopy = execCxt.getContext().copy();
                    r = ServiceEnhancerInit.execute(op, dataset, binding, cxtCopy);
                }
            } else {
                r = chain.createExecution(opExec, opOrig, binding, execCxt);
            }
            return r;
        };
        registry.addSingleLink(selfExec);
    }

    private static QueryIterator execute(Op op, DatasetGraph dataset, Binding binding, Context cxt) {
        QueryIterator innerIter = null;
        QueryIterator outerIter = null;
        ExecutionContext execCxt = null;
        DynamicDatasets.DynamicDatasetGraph ddg = DynamicDatasetUtils.asUnwrappableDynamicDatasetOrNull(dataset);
        if (ddg != null) {
            Set visibleVars = OpVars.visibleVars((Op)op);
            BiMap normedToScoped = VarScopeUtils.normalizeVarScopes(visibleVars).inverse();
            Op opRestored = Rename.reverseVarRename((Op)op, (boolean)true);
            Query baseQuery = OpAsQuery.asQuery((Op)opRestored);
            Pair<Query, DatasetGraph> pair = DynamicDatasetUtils.unwrap(baseQuery, (DatasetGraph)ddg);
            Query effQuery = (Query)pair.getLeft();
            DatasetGraph effDataset = (DatasetGraph)pair.getRight();
            QueryEngineFactory qef = QueryEngineRegistry.findFactory((Query)effQuery, (DatasetGraph)effDataset, (Context)cxt);
            Plan plan = qef.create(effQuery, effDataset, BindingFactory.empty(), cxt);
            innerIter = plan.iterator();
            outerIter = new QueryIteratorMapped(innerIter, (Map)normedToScoped);
        }
        if (innerIter == null) {
            QueryEngineFactory qef = QueryEngineRegistry.findFactory((Op)op, (DatasetGraph)dataset, (Context)cxt);
            Plan plan = qef.create(op, dataset, BindingFactory.empty(), cxt);
            outerIter = innerIter = plan.iterator();
        }
        execCxt = innerIter instanceof QueryIter ? ((QueryIter)innerIter).getExecContext() : null;
        QueryIterCommonParent result = new QueryIterCommonParent(outerIter, binding, execCxt);
        return result;
    }

    static void registerWith(AssemblerGroup g) {
        AssemblerUtils.register((AssemblerGroup)g, (Resource)ServiceEnhancerVocab.DatasetServiceEnhancer, (Assembler)new DatasetAssemblerServiceEnhancer(), (Resource)DatasetAssembler.getGeneralType());
    }

    public static void wrapOptimizer(Context tgt, Context src) {
        if (tgt == src) {
            throw new IllegalArgumentException("Target and source contexts for optimizer must differ to avoid infinite loop during lookup");
        }
        RewriteFactory baseFactory = (RewriteFactory)tgt.get(ARQConstants.sysOptimizerFactory);
        if (baseFactory == null) {
            ServiceEnhancerInit.wrapOptimizer(tgt);
        } else {
            RewriteFactory factory = cxt -> op -> {
                RewriteFactory f = ServiceEnhancerInit.decideOptimizer(src);
                f = ServiceEnhancerInit.enhance(f);
                Context mergedCxt = Context.mergeCopy((Context)src, (Context)cxt);
                Rewrite r = f.create(mergedCxt);
                return r.rewrite(op);
            };
            tgt.set(ARQConstants.sysOptimizerFactory, (Object)factory);
        }
    }

    public static RewriteFactory decideOptimizer(Context context) {
        RewriteFactory result = (RewriteFactory)context.get(ARQConstants.sysOptimizerFactory);
        if (result == null && (result = Optimize.getFactory()) == null) {
            result = Optimize.stdOptimizationFactory;
        }
        return result;
    }

    public static void wrapOptimizer(Context cxt) {
        RewriteFactory baseFactory = ServiceEnhancerInit.decideOptimizer(cxt);
        RewriteFactory enhancedFactory = ServiceEnhancerInit.enhance(baseFactory);
        cxt.set(ARQConstants.sysOptimizerFactory, (Object)enhancedFactory);
    }

    public static RewriteFactory enhance(RewriteFactory baseFactory) {
        RewriteFactory enhancedFactory = cxt -> {
            Rewrite baseRewrite = baseFactory.create(cxt);
            Rewrite[] rw = new Rewrite[]{null};
            rw[0] = op -> {
                Op a = Transformer.transform((Transform)new TransformSE_EffectiveOptions(), (Op)op);
                Op b = Transformer.transform((Transform)new TransformSE_JoinStrategy(), (Op)a);
                Op r = baseRewrite.rewrite(b);
                Op q = Transformer.transform((Transform)new TransformSE_JoinStrategy(), (Op)r);
                return q;
            };
            return rw[0];
        };
        return enhancedFactory;
    }

    public static Node resolveServiceNode(Node node, ExecutionContext execCxt) {
        Node result = ServiceEnhancerConstants.SELF.equals((Object)node) ? ServiceEnhancerInit.resolveSelfId(execCxt) : node;
        return result;
    }

    public static Node resolveSelfId(ExecutionContext execCxt) {
        Context context = execCxt.getContext();
        Node id = (Node)context.get(ServiceEnhancerConstants.datasetId);
        if (id == null) {
            DatasetGraph dg = execCxt.getDataset();
            int hashCode = System.identityHashCode(dg);
            id = NodeFactory.createLiteralString((String)(ServiceEnhancerConstants.SELF.getURI() + "@dataset" + hashCode));
        }
        return id;
    }
}

