/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl.util;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.function.Function;
import org.apache.jena.query.Query;

public class RangeUtils {
    public static <C extends Comparable<C>> RangeSet<C> gaps(Range<C> requestRange, RangeSet<C> availableRanges) {
        RangeSet absentRanges = availableRanges.complement();
        RangeSet gaps = absentRanges.subRangeSet(requestRange);
        return gaps;
    }

    public static Range<Long> toRange(Query query) {
        Range<Long> result = RangeUtils.toRange(query.getOffset(), query.getLimit());
        return result;
    }

    public static Range<Long> toRange(Long offset, Long limit) {
        Long min = offset == null || offset.equals(Long.MIN_VALUE) ? 0L : offset;
        Long delta = limit == null || limit.equals(Long.MIN_VALUE) ? null : limit;
        Long max = delta == null ? null : Long.valueOf(min + delta);
        Range result = max == null ? Range.atLeast((Comparable)min) : Range.closedOpen((Comparable)min, (Comparable)max);
        return result;
    }

    public static Range<Long> shiftLong(Range<Long> rawRange, long distance) {
        return RangeUtils.map(rawRange, v -> v + distance);
    }

    public static <I extends Comparable<I>, O extends Comparable<O>> Range<O> map(Range<I> range, Function<? super I, ? extends O> mapper) {
        Range result = range.hasLowerBound() ? (range.hasUpperBound() ? Range.range((Comparable)((Comparable)mapper.apply(range.lowerEndpoint())), (BoundType)range.lowerBoundType(), (Comparable)((Comparable)mapper.apply(range.upperEndpoint())), (BoundType)range.upperBoundType()) : Range.downTo((Comparable)((Comparable)mapper.apply(range.lowerEndpoint())), (BoundType)range.lowerBoundType())) : (range.hasUpperBound() ? Range.upTo((Comparable)((Comparable)mapper.apply(range.upperEndpoint())), (BoundType)range.upperBoundType()) : Range.all());
        return result;
    }
}

