/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl.util;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import java.util.Collection;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.LongStream;

public class PageUtils {
    public static long getPageIndexForOffset(long offset, long pageSize) {
        return offset / pageSize;
    }

    public static long getIndexInPage(long offset, long pageSize) {
        return offset % pageSize;
    }

    public static int getIndexInPage(long offset, int pageSize) {
        return (int)(offset % (long)pageSize);
    }

    public static long getPageOffsetForId(long pageId, long pageSize) {
        return pageId * pageSize;
    }

    public static LongStream touchedPageIndices(Range<Long> range, long pageSize) {
        ContiguousSet set = ContiguousSet.create(range, (DiscreteDomain)DiscreteDomain.longs());
        LongStream result = set.isEmpty() ? LongStream.empty() : LongStream.rangeClosed(PageUtils.getPageIndexForOffset((Long)set.first(), pageSize), PageUtils.getPageIndexForOffset((Long)set.last(), pageSize));
        return result;
    }

    public static NavigableSet<Long> touchedPageIndices(Collection<Range<Long>> ranges, long pageSize) {
        NavigableSet result = ranges.stream().flatMapToLong(range -> PageUtils.touchedPageIndices((Range<Long>)range, pageSize)).boxed().collect(Collectors.toCollection(TreeSet::new));
        return result;
    }
}

