/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl.util;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import org.apache.jena.sparql.service.enhancer.impl.util.ThrowingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockUtils {
    private static final Logger logger = LoggerFactory.getLogger(LockUtils.class);

    public static <T> T runWithLock(Lock lock, Callable<T> action) {
        T result = null;
        try {
            lock.lock();
            result = action.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    public static void runWithLock(Lock lock, ThrowingRunnable action) {
        LockUtils.runWithLock(lock, () -> {
            action.run();
            return null;
        });
    }

    public static <T, L extends Lock> T runWithMgmtLock(L lock, Consumer<? super L> forceUnlock, Duration duration, Callable<T> action) {
        T result = null;
        try {
            long timeout = duration.toMillis();
            boolean isLocked = lock.tryLock(timeout, TimeUnit.MILLISECONDS);
            if (!isLocked) {
                logger.warn(String.format("Forcibly unlocking stale lock %s", lock));
                forceUnlock.accept(lock);
                isLocked = lock.tryLock(timeout, TimeUnit.MILLISECONDS);
                if (!isLocked) {
                    throw new RuntimeException("Failed to acquire lock despite forced unlocking");
                }
            }
            result = action.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
        return result;
    }
}

