/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl.util;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.sparql.service.enhancer.impl.util.PeekIteratorLazy;

public class IteratorUtils {
    public static <K, X, Y> AbstractIterator<Table.Cell<K, X, Iterator<Y>>> partialLeftMergeJoin(Iterator<X> lhs, Iterator<Y> rhs, Function<X, K> xToK, Function<Y, K> yToK) {
        final Iterator lhsKvIt = Iter.map(lhs, x -> new AbstractMap.SimpleEntry(xToK.apply(x), x));
        Iterator rawRhsKvIt = Iter.map(rhs, v -> new AbstractMap.SimpleEntry(yToK.apply(v), v));
        final PeekIteratorLazy rhsKvIt = PeekIteratorLazy.create(rawRhsKvIt);
        AbstractIterator result = new AbstractIterator<Table.Cell<K, X, Iterator<Y>>>(){

            protected Table.Cell<K, X, Iterator<Y>> computeNext() {
                Table.Cell r;
                if (lhsKvIt.hasNext()) {
                    Map.Entry lhsE = (Map.Entry)lhsKvIt.next();
                    final Object lhsK = lhsE.getKey();
                    Object x = lhsE.getValue();
                    Iterator<Object> rhsSubIt = null;
                    if (rhsKvIt.hasNext()) {
                        Map.Entry e = (Map.Entry)rhsKvIt.peek();
                        Object rhsK = e.getKey();
                        rhsSubIt = Objects.equals(lhsK, rhsK) ? new AbstractIterator<Y>(){

                            protected Y computeNext() {
                                Object rhsR;
                                if (rhsKvIt.hasNext()) {
                                    Map.Entry subE = (Map.Entry)rhsKvIt.peek();
                                    Object subK = subE.getKey();
                                    if (Objects.equals(lhsK, subK)) {
                                        rhsR = subE.getValue();
                                        rhsKvIt.next();
                                    } else {
                                        rhsR = this.endOfData();
                                    }
                                } else {
                                    rhsR = this.endOfData();
                                }
                                return rhsR;
                            }
                        } : Collections.emptyIterator();
                    }
                    r = Tables.immutableCell(lhsK, x, rhsSubIt);
                } else {
                    r = (Table.Cell)this.endOfData();
                }
                return r;
            }
        };
        return result;
    }

    public static void mainBasic() {
        List<Integer> lhs = Arrays.asList(1, 4, 5, 8, 9, 11, 12);
        ArrayList<AbstractMap.SimpleEntry<Integer, String>> rhs = new ArrayList<AbstractMap.SimpleEntry<Integer, String>>();
        rhs.add(new AbstractMap.SimpleEntry<Integer, String>(4, "fourA"));
        rhs.add(new AbstractMap.SimpleEntry<Integer, String>(4, "fourB"));
        rhs.add(new AbstractMap.SimpleEntry<Integer, String>(8, "eightA"));
        rhs.add(new AbstractMap.SimpleEntry<Integer, String>(8, "eightB"));
        rhs.add(new AbstractMap.SimpleEntry<Integer, String>(9, "nineA"));
        AbstractIterator<Table.Cell<Object, Integer, Iterator<Map.Entry>>> it = IteratorUtils.partialLeftMergeJoin(lhs.iterator(), rhs.iterator(), x -> x, Map.Entry::getKey);
        while (it.hasNext()) {
            Table.Cell cell = (Table.Cell)it.next();
            System.out.println(String.valueOf(cell.getColumnKey()) + ":");
            Iterator subIt = (Iterator)cell.getValue();
            if (subIt == null) {
                System.out.println("  No more items");
                continue;
            }
            subIt.forEachRemaining(x -> System.out.println("  " + String.valueOf(x)));
        }
    }

    public static void main(String[] args) {
        List<Integer> lhs = Arrays.asList(1, 4, 5, 8, 9, 11, 12, 666);
        ArrayList<AbstractMap.SimpleEntry<Integer, String>> rhs = new ArrayList<AbstractMap.SimpleEntry<Integer, String>>();
        rhs.add(new AbstractMap.SimpleEntry<Integer, String>(4, "fourA"));
        rhs.add(new AbstractMap.SimpleEntry<Integer, String>(4, "fourB"));
        rhs.add(new AbstractMap.SimpleEntry<Integer, String>(8, "eightA"));
        rhs.add(new AbstractMap.SimpleEntry<Integer, String>(8, "eightB"));
        rhs.add(new AbstractMap.SimpleEntry<Integer, String>(9, "nineA"));
        rhs.add(new AbstractMap.SimpleEntry<Integer, String>(666, "endMarker"));
        AbstractIterator<Table.Cell<Object, Integer, Iterator<Map.Entry>>> it = IteratorUtils.partialLeftMergeJoin(lhs.iterator(), rhs.iterator(), x -> x, Map.Entry::getKey);
        while (it.hasNext()) {
            Table.Cell cell = (Table.Cell)it.next();
            Integer key = (Integer)cell.getColumnKey();
            System.out.println(key + ":");
            Iterator subIt = (Iterator)cell.getValue();
            if (subIt == null) {
                System.out.println("  No more items");
                continue;
            }
            subIt.forEachRemaining(x -> System.out.println("  " + String.valueOf(x)));
            if (!Objects.equals(key, 666)) continue;
            System.out.println("End marker reached");
        }
    }
}

