/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl.util;

import java.util.Optional;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.service.enhancer.impl.util.NodeUtilsExtra;
import org.apache.jena.sparql.util.graph.GraphUtils;

public class GraphUtilsExtra {
    public static Number getAsNumber(Resource resource, Property property) {
        Number result = null;
        RDFNode rdfNode = GraphUtils.getAsRDFNode((Resource)resource, (Property)property);
        if (rdfNode != null) {
            Node node = rdfNode.asNode();
            result = NodeUtilsExtra.getNumberOrNull(node);
        }
        return result;
    }

    public static int getAsInt(Resource resource, Property property, int fallback) {
        return Optional.ofNullable(GraphUtilsExtra.getAsNumber(resource, property)).map(Number::intValue).orElse(fallback);
    }

    public static long getAsLong(Resource resource, Property property, long fallback) {
        return Optional.ofNullable(GraphUtilsExtra.getAsNumber(resource, property)).map(Number::longValue).orElse(fallback);
    }
}

