/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.jena.sparql.service.enhancer.impl.util.ThrowingRunnable;

public class FinallyRunAll
implements Runnable {
    protected List<ThrowingRunnable> actions;

    public static FinallyRunAll create() {
        return new FinallyRunAll();
    }

    public FinallyRunAll() {
        this(new ArrayList<ThrowingRunnable>());
    }

    public FinallyRunAll(List<ThrowingRunnable> actions) {
        this.actions = actions;
    }

    public void addThrowing(ThrowingRunnable action) {
        this.actions.add(action);
    }

    public void add(Callable<?> callable) {
        this.addThrowing(() -> callable.call());
    }

    public void add(Runnable runnable) {
        this.addThrowing(runnable::run);
    }

    @Override
    public void run() {
        this.runAction(0);
    }

    protected void runAction(int index) {
        if (index < this.actions.size()) {
            ThrowingRunnable action = this.actions.get(index);
            try {
                action.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.runAction(index + 1);
            }
        }
    }

    public static void run(ThrowingRunnable ... actions) {
        new FinallyRunAll(Arrays.asList(actions)).run();
    }
}

