/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.service.enhancer.impl.util.CollectionUtils;
import org.apache.jena.sparql.service.enhancer.impl.util.NodeUtilsExtra;
import org.apache.jena.sparql.syntax.syntaxtransform.NodeTransformSubst;

public class BindingUtils {
    public static Binding project(Binding binding, Iterator<Var> vars) {
        BindingBuilder builder = BindingBuilder.create();
        while (vars.hasNext()) {
            Var var = vars.next();
            Node node = binding.get(var);
            if (node == null) continue;
            builder.add(var, node);
        }
        return builder.build();
    }

    public static Binding project(Binding binding, Iterator<Var> vars, Var exclusion) {
        return BindingUtils.project(binding, Iter.filterDrop(vars, v -> Objects.equals(v, exclusion)));
    }

    public static Binding project(Binding binding, Iterator<Var> vars, Set<Var> exclusions) {
        return BindingUtils.project(binding, Iter.filterDrop(vars, exclusions::contains));
    }

    public static <C extends Collection<Var>> C addAll(C acc, Binding binding) {
        Iterator it = binding.vars();
        while (it.hasNext()) {
            Var v = (Var)it.next();
            acc.add((Var)v);
        }
        return acc;
    }

    public static <C extends Collection<Var>> C varsMentioned(C out, Iterator<Binding> it) {
        while (it.hasNext()) {
            Binding b = it.next();
            CollectionUtils.addAll(out, b.vars());
        }
        return out;
    }

    public static Binding renameKeys(Binding binding, Map<Var, Var> varMap) {
        return NodeTransformLib.transform((Binding)binding, (NodeTransform)new NodeTransformSubst(varMap));
    }

    public static Set<Var> varsMentioned(Iterable<Binding> bindings) {
        LinkedHashSet result = new LinkedHashSet();
        return BindingUtils.varsMentioned(result, bindings.iterator());
    }

    public static Set<Var> varsMentioned(Binding binding) {
        LinkedHashSet<Var> result = new LinkedHashSet<Var>();
        binding.vars().forEachRemaining(result::add);
        return result;
    }

    public static Number getNumberOrNull(Binding binding, Var var) {
        Node node = binding.get(var);
        Number result = NodeUtilsExtra.getNumberOrNull(node);
        return result;
    }

    public static Number getNumber(Binding binding, Var var) {
        return Objects.requireNonNull(BindingUtils.getNumberOrNull(binding, var), "Number must not be null");
    }
}

