/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl.util;

import org.apache.jena.sparql.service.enhancer.impl.util.AutoCloseableBase;
import org.apache.jena.sparql.service.enhancer.impl.util.StackTraceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCloseableWithLeakDetectionBase
extends AutoCloseableBase {
    private static final Logger logger = LoggerFactory.getLogger(AutoCloseableWithLeakDetectionBase.class);
    protected final StackTraceElement[] instantiationStackTrace = StackTraceUtils.getStackTraceIfEnabled();

    public StackTraceElement[] getInstantiationStackTrace() {
        return this.instantiationStackTrace;
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.isClosed) {
                String str = StackTraceUtils.toString(this.instantiationStackTrace);
                logger.warn("Close invoked via GC rather than user logic - indicates resource leak. Object constructed at " + str);
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }
}

