/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.service.enhancer.impl.Estimate;
import org.apache.jena.sparql.service.enhancer.init.ServiceEnhancerConstants;
import org.apache.jena.sparql.util.Context;

public class ServiceResultSizeCache {
    protected Cache<Node, Estimate<Long>> serviceToLimit = CacheBuilder.newBuilder().maximumSize(10000L).build();

    public Estimate<Long> getLimit(Node service) {
        Estimate<Long> result = (Estimate<Long>)this.serviceToLimit.getIfPresent((Object)service);
        if (result == null) {
            result = new Estimate<Long>(0L, false);
        }
        return result;
    }

    public void updateLimit(Node service, Estimate<Long> estimate) {
        this.serviceToLimit.put((Object)service, estimate);
    }

    public void invalidateAll() {
        this.serviceToLimit.invalidateAll();
    }

    public static ServiceResultSizeCache get() {
        return ServiceResultSizeCache.get(ARQ.getContext());
    }

    public static ServiceResultSizeCache get(Context cxt) {
        return (ServiceResultSizeCache)cxt.get(ServiceEnhancerConstants.serviceResultSizeCache);
    }

    public static void set(Context cxt, ServiceResultSizeCache cache) {
        cxt.put(ServiceEnhancerConstants.serviceResultSizeCache, (Object)cache);
    }
}

