/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.service.enhancer.claimingcache.AsyncClaimingCache;
import org.apache.jena.sparql.service.enhancer.claimingcache.AsyncClaimingCacheImplGuava;
import org.apache.jena.sparql.service.enhancer.claimingcache.RefFuture;
import org.apache.jena.sparql.service.enhancer.impl.ServiceCacheKey;
import org.apache.jena.sparql.service.enhancer.impl.ServiceCacheValue;
import org.apache.jena.sparql.service.enhancer.init.ServiceEnhancerConstants;
import org.apache.jena.sparql.service.enhancer.slice.api.ArrayOps;
import org.apache.jena.sparql.service.enhancer.slice.api.Slice;
import org.apache.jena.sparql.service.enhancer.slice.impl.SliceInMemoryCache;
import org.apache.jena.sparql.util.Context;

public class ServiceResponseCache {
    public static final int DFT_MAX_ENTRY_COUNT = 300;
    public static final int DFT_PAGE_SIZE = 10000;
    public static final int DFT_MAX_PAGE_COUNT = 15;
    protected AsyncClaimingCache<ServiceCacheKey, ServiceCacheValue> cache;
    protected AtomicLong entryCounter = new AtomicLong(0L);
    protected Map<Long, ServiceCacheKey> idToKey = new ConcurrentHashMap<Long, ServiceCacheKey>();

    public ServiceResponseCache() {
        this(300, 10000, 15);
    }

    public ServiceResponseCache(int maxCacheSize, int pageSize, int maxPageCount) {
        AsyncClaimingCacheImplGuava.Builder<Object, Object> builder = AsyncClaimingCacheImplGuava.newBuilder((CacheBuilder<Object, Object>)CacheBuilder.newBuilder().maximumSize((long)maxCacheSize));
        builder = builder.setCacheLoader(key -> {
            long id = this.entryCounter.getAndIncrement();
            this.idToKey.put(id, (ServiceCacheKey)key);
            Slice<T[]> slice = SliceInMemoryCache.create(ArrayOps.createFor(Binding.class), pageSize, maxPageCount);
            ServiceCacheValue r = new ServiceCacheValue(id, slice);
            Log.debug(ServiceResponseCache.class, (String)("Loaded cache entry: " + id));
            return r;
        }).setAtomicRemovalListener((RemovalListener<ServiceCacheKey, ServiceCacheValue>)((RemovalListener)n -> {
            ServiceCacheValue v = (ServiceCacheValue)n.getValue();
            if (v != null) {
                long id = v.getId();
                Log.debug(ServiceResponseCache.class, (String)("Removed cache entry: " + id));
                this.idToKey.remove(id);
            }
        }));
        this.cache = builder.build();
    }

    public AsyncClaimingCache<ServiceCacheKey, ServiceCacheValue> getCache() {
        return this.cache;
    }

    public RefFuture<ServiceCacheValue> claim(ServiceCacheKey key) {
        return this.cache.claim(key);
    }

    public Map<Long, ServiceCacheKey> getIdToKey() {
        return this.idToKey;
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public static ServiceResponseCache get() {
        return ServiceResponseCache.get(ARQ.getContext());
    }

    public static ServiceResponseCache get(Context cxt) {
        return (ServiceResponseCache)cxt.get(ServiceEnhancerConstants.serviceCache);
    }

    public static void set(Context cxt, ServiceResponseCache cache) {
        cxt.put(ServiceEnhancerConstants.serviceCache, (Object)cache);
    }
}

