/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.service.enhancer.init.ServiceEnhancerConstants;

public class ServiceOpts {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?<!(esc))(?:(esc){2})*(sep)".replace("(esc)", ":").replace("(sep)", ":"));
    public static final String SO_OPTIMIZE = "optimize";
    public static final String SO_CACHE = "cache";
    public static final String SO_BULK = "bulk";
    public static final String SO_LOOP = "loop";
    protected OpService opService;
    protected List<Map.Entry<String, String>> options;

    public ServiceOpts(OpService opService, List<Map.Entry<String, String>> options) {
        this.opService = opService;
        this.options = options;
    }

    public OpService getTargetService() {
        return this.opService;
    }

    public ServiceOpts copy() {
        return new ServiceOpts(this.opService, new ArrayList<Map.Entry<String, String>>(this.options));
    }

    public void add(String key, String value) {
        this.options.add(new AbstractMap.SimpleEntry<String, String>(key, value));
    }

    public void removeKey(Object key) {
        Iterator<Map.Entry<String, String>> it = this.options.iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> e = it.next();
            if (!Objects.equals(e.getKey(), key)) continue;
            it.remove();
        }
    }

    public List<Map.Entry<String, String>> getOptions() {
        return this.options;
    }

    public boolean containsKey(Object key) {
        boolean result = this.options.stream().anyMatch(e -> Objects.equals(e.getKey(), key));
        return result;
    }

    public String getFirstValue(Object key, String valueIfNull, String valueIfAbsent) {
        String result = this.options.stream().filter(e -> Objects.equals(e.getKey(), key)).map(e -> {
            String r = (String)e.getValue();
            if (r == null) {
                r = valueIfNull;
            }
            return r;
        }).findFirst().orElse(valueIfAbsent);
        return result;
    }

    public OpService toService() {
        OpService result;
        if (this.options.isEmpty()) {
            result = this.opService;
        } else {
            Node node = this.opService.getService();
            String prefixStr = ServiceOpts.unparse(this.options);
            if (!node.isURI()) {
                Node uri = NodeFactory.createURI((String)prefixStr);
                result = new OpService(uri, (Op)this.opService, false);
            } else {
                Node uri = NodeFactory.createURI((String)(prefixStr + node.getURI()));
                result = new OpService(uri, this.opService.getSubOp(), false);
            }
        }
        return result;
    }

    public String toString() {
        return "ServiceOpts [options=" + String.valueOf(this.options) + ", opService=" + String.valueOf(this.opService) + "]";
    }

    public static List<Map.Entry<String, String>> parseAsOptions(Node node) {
        String iri = node.isURI() ? node.getURI() : null;
        List<Map.Entry<String, String>> result = iri == null ? null : ServiceOpts.parseAsOptions(iri);
        return result;
    }

    public static List<Map.Entry<String, String>> parseAsOptions(String iri) {
        String[] rawSplits;
        ArrayList<Map.Entry<String, String>> result = new ArrayList<Map.Entry<String, String>>();
        for (String rawSplit : rawSplits = SPLIT_PATTERN.split(iri)) {
            String split = rawSplit.replace("\\\\", "\\");
            String[] kv = split.split("\\+", 2);
            result.add(new AbstractMap.SimpleEntry<String, Object>(kv[0], (kv.length == 2 ? kv[1] : null)));
        }
        return result;
    }

    public static String escape(String str) {
        String result = str.replace("\\", "\\\\").replace(":", "\\:");
        return result;
    }

    public static String unparse(List<Map.Entry<String, String>> optionList) {
        Map.Entry<String, String> lastEntry;
        Object result = optionList.stream().map(e -> ServiceOpts.escape((String)e.getKey()) + Optional.ofNullable((String)e.getValue()).map(v -> "+" + ServiceOpts.escape(v)).orElse("")).collect(Collectors.joining(":"));
        ListIterator<Map.Entry<String, String>> it = optionList.listIterator(optionList.size());
        if (it.hasPrevious() && ServiceOpts.isKnownOption((lastEntry = it.previous()).getKey())) {
            result = (String)result + ":";
        }
        return result;
    }

    public static boolean isKnownOption(String key) {
        LinkedHashSet<String> knownOptions = new LinkedHashSet<String>();
        knownOptions.add(SO_CACHE);
        knownOptions.add(SO_BULK);
        knownOptions.add(SO_LOOP);
        knownOptions.add(SO_OPTIMIZE);
        return knownOptions.contains(key);
    }

    public static ServiceOpts getEffectiveService(OpService opService) {
        boolean isSilent;
        String serviceStr;
        OpService currentOp;
        ArrayList<Map.Entry<String, String>> opts;
        block2: {
            opts = new ArrayList<Map.Entry<String, String>>();
            currentOp = opService;
            serviceStr = null;
            while (true) {
                Map.Entry<String, String> e;
                String key;
                int i;
                isSilent = currentOp.getSilent();
                Node node = currentOp.getService();
                List<Map.Entry<String, String>> parts = ServiceOpts.parseAsOptions(node);
                if (parts == null) break block2;
                int n = parts.size();
                for (i = 0; i < n && ServiceOpts.isKnownOption(key = (e = parts.get(i)).getKey()); ++i) {
                    opts.add(e);
                }
                List<Map.Entry<String, String>> subList = parts.subList(i, n);
                serviceStr = ServiceOpts.unparse(subList);
                if (!serviceStr.isEmpty()) break block2;
                Op subOp = opService.getSubOp();
                if (!(subOp instanceof OpService)) break;
                currentOp = (OpService)subOp;
            }
            serviceStr = ServiceEnhancerConstants.SELF.getURI();
        }
        ServiceOpts result = opts.isEmpty() ? new ServiceOpts(opService, opts) : new ServiceOpts(new OpService(NodeFactory.createURI(serviceStr), currentOp.getSubOp(), isSilent), opts);
        return result;
    }
}

