/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.service.enhancer.impl.OpServiceInfo;
import org.apache.jena.sparql.service.enhancer.impl.ServiceCacheKey;

public class ServiceCacheKeyFactory {
    protected OpServiceInfo serviceInfo;
    protected Map<Var, Var> joinVarMap;
    protected NodeTransform serviceNodeRemapper;

    public ServiceCacheKeyFactory(OpServiceInfo serviceInfo, Map<Var, Var> joinVarMap, NodeTransform serviceNodeRemapper) {
        this.serviceInfo = serviceInfo;
        this.joinVarMap = joinVarMap;
        this.serviceNodeRemapper = serviceNodeRemapper;
    }

    public Map<Var, Var> getJoinVarMap() {
        return this.joinVarMap;
    }

    public ServiceCacheKey createCacheKey(Binding binding) {
        Node serviceNode = Substitute.substitute((Node)this.serviceInfo.getServiceNode(), (Binding)binding);
        Node effServiceNode = (Node)this.serviceNodeRemapper.apply((Object)serviceNode);
        if (effServiceNode == null) {
            effServiceNode = serviceNode;
        }
        Op op = this.serviceInfo.getNormedQueryOp();
        BindingBuilder joinbb = BindingFactory.builder();
        binding.forEach((v, n) -> {
            Var effectiveVar = this.joinVarMap.get(v);
            if (effectiveVar != null) {
                joinbb.add(effectiveVar, n);
            }
        });
        Binding joinBinding = joinbb.build();
        ServiceCacheKey result = new ServiceCacheKey(effServiceNode, op, joinBinding);
        return result;
    }

    public static Map<Var, Var> createJoinVarMapScopedToNormed(OpServiceInfo serviceInfo, Set<Var> lhsBindingVarsScoped) {
        Map<Var, Var> rhsVarsScopedToNormed = serviceInfo.getMentionedSubOpVarsScopedToNormed();
        Map<Var, Var> joinVarMap = Sets.intersection(lhsBindingVarsScoped, rhsVarsScopedToNormed.keySet()).stream().collect(Collectors.toMap(x -> x, rhsVarsScopedToNormed::get));
        return joinVarMap;
    }

    public static ServiceCacheKeyFactory createCacheKeyFactory(OpServiceInfo serviceInfo, Set<Var> lhsBindingVarsScoped, NodeTransform serviceNodeRemapper) {
        Map<Var, Var> joinVarMap = ServiceCacheKeyFactory.createJoinVarMapScopedToNormed(serviceInfo, lhsBindingVarsScoped);
        return new ServiceCacheKeyFactory(serviceInfo, joinVarMap, serviceNodeRemapper);
    }
}

