/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl;

import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.engine.binding.Binding;

public class ServiceCacheKey {
    protected Node serviceNode;
    protected Op op;
    protected Binding binding;

    public ServiceCacheKey(Node serviceNode, Op op, Binding binding) {
        this.serviceNode = serviceNode;
        this.op = op;
        this.binding = binding;
    }

    public Node getServiceNode() {
        return this.serviceNode;
    }

    public Op getOp() {
        return this.op;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public int hashCode() {
        return Objects.hash(this.binding, this.op, this.serviceNode);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceCacheKey other = (ServiceCacheKey)obj;
        return Objects.equals(this.binding, other.binding) && Objects.equals(this.op, other.op) && Objects.equals(this.serviceNode, other.serviceNode);
    }

    public String toString() {
        return "ServiceCacheKey [serviceNode=" + String.valueOf(this.serviceNode) + ", op=" + String.valueOf(this.op) + ", binding=" + String.valueOf(this.binding) + "]";
    }
}

