/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.jena.atlas.iterator.IteratorCloseable;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIterConvert;
import org.apache.jena.sparql.engine.iterator.QueryIterPeek;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.service.enhancer.impl.Batch;
import org.apache.jena.sparql.service.enhancer.impl.BatchQueryRewriter;
import org.apache.jena.sparql.service.enhancer.impl.BatchQueryRewriterBuilder;
import org.apache.jena.sparql.service.enhancer.impl.CacheMode;
import org.apache.jena.sparql.service.enhancer.impl.GroupedBatch;
import org.apache.jena.sparql.service.enhancer.impl.OpServiceExecutor;
import org.apache.jena.sparql.service.enhancer.impl.OpServiceExecutorImpl;
import org.apache.jena.sparql.service.enhancer.impl.OpServiceInfo;
import org.apache.jena.sparql.service.enhancer.impl.QueryIterServiceBulk;
import org.apache.jena.sparql.service.enhancer.impl.ServiceCacheKeyFactory;
import org.apache.jena.sparql.service.enhancer.impl.ServiceOpts;
import org.apache.jena.sparql.service.enhancer.impl.ServiceResponseCache;
import org.apache.jena.sparql.service.enhancer.impl.ServiceResultSizeCache;
import org.apache.jena.sparql.service.enhancer.impl.util.BindingUtils;
import org.apache.jena.sparql.service.enhancer.impl.util.QueryIterSlottedBase;
import org.apache.jena.sparql.service.enhancer.impl.util.VarUtilsExtra;
import org.apache.jena.sparql.service.enhancer.init.ServiceEnhancerConstants;
import org.apache.jena.sparql.service.enhancer.init.ServiceEnhancerInit;

public class RequestExecutor
extends QueryIterSlottedBase {
    protected OpServiceInfo serviceInfo;
    protected int fetchAhead = 5;
    protected int maxRequestSize = 2000;
    protected OpServiceExecutor opExecutor;
    protected ExecutionContext execCxt;
    protected ServiceResultSizeCache resultSizeCache;
    protected ServiceResponseCache cache;
    protected CacheMode cacheMode;
    protected IteratorCloseable<GroupedBatch<Node, Long, Binding>> batchIterator;
    protected Var globalIdxVar;
    protected long currentInputId = -1L;
    protected QueryIterPeek activeIter;
    protected Map<Long, Binding> inputToBinding = new HashMap<Long, Binding>();
    protected Map<Long, QueryIterPeek> inputToOutputIt = new LinkedHashMap<Long, QueryIterPeek>();
    protected Set<Long> inputToClose = new HashSet<Long>();

    public RequestExecutor(OpServiceExecutorImpl opExector, OpServiceInfo serviceInfo, ServiceResultSizeCache resultSizeCache, ServiceResponseCache cache, CacheMode cacheMode, IteratorCloseable<GroupedBatch<Node, Long, Binding>> batchIterator) {
        this.opExecutor = opExector;
        this.serviceInfo = serviceInfo;
        this.resultSizeCache = resultSizeCache;
        this.cache = cache;
        this.cacheMode = cacheMode;
        this.batchIterator = batchIterator;
        Set<Var> visibleServiceSubOpVars = serviceInfo.getVisibleSubOpVarsScoped();
        this.globalIdxVar = VarUtilsExtra.freshVar("__idx__", visibleServiceSubOpVars);
        this.execCxt = opExector.getExecCxt();
        this.activeIter = QueryIterPeek.create((QueryIterator)QueryIterPlainWrapper.create(Collections.emptyList().iterator(), (ExecutionContext)this.execCxt), (ExecutionContext)this.execCxt);
    }

    protected Binding moveToNext() {
        Binding parentBinding = null;
        Binding childBindingWithIdx = null;
        while (true) {
            boolean isClosePoint;
            if (this.activeIter.hasNext()) {
                boolean matchesCurrentPartition;
                Binding peek = this.activeIter.peek();
                long peekOutputId = BindingUtils.getNumber(peek, this.globalIdxVar).longValue();
                boolean bl = matchesCurrentPartition = peekOutputId == this.currentInputId;
                if (matchesCurrentPartition) {
                    parentBinding = this.inputToBinding.get(this.currentInputId);
                    childBindingWithIdx = this.activeIter.next();
                    break;
                }
            }
            if (isClosePoint = this.inputToClose.contains(this.currentInputId)) {
                QueryIterPeek it = this.inputToOutputIt.get(this.currentInputId);
                it.close();
                this.inputToClose.remove(this.currentInputId);
            }
            this.inputToBinding.remove(this.currentInputId);
            ++this.currentInputId;
            if (!this.inputToOutputIt.containsKey(this.currentInputId) && this.batchIterator.hasNext()) {
                this.prepareNextBatchExec();
            }
            if (!this.inputToOutputIt.containsKey(this.currentInputId)) break;
            this.activeIter = this.inputToOutputIt.get(this.currentInputId);
        }
        Binding result = null;
        if (childBindingWithIdx != null) {
            Binding childBinding = BindingUtils.project(childBindingWithIdx, (Iterator<Var>)childBindingWithIdx.vars(), this.globalIdxVar);
            result = BindingFactory.builder((Binding)parentBinding).addAll(childBinding).build();
        }
        if (result == null) {
            this.freeResources();
        }
        return result;
    }

    public void prepareNextBatchExec() {
        QueryIterServiceBulk baseIt;
        GroupedBatch batchRequest = (GroupedBatch)this.batchIterator.next();
        ServiceOpts so = ServiceOpts.getEffectiveService(this.serviceInfo.getOpService());
        Node targetServiceNode = so.getTargetService().getService();
        Batch batch = batchRequest.getBatch();
        NavigableMap batchItems = batch.getItems();
        ArrayList<Binding> inputs = new ArrayList<Binding>(batchItems.values());
        NodeTransform serviceNodeRemapper = node -> ServiceEnhancerInit.resolveServiceNode(node, this.execCxt);
        Set<Var> inputVarsMentioned = BindingUtils.varsMentioned(inputs);
        ServiceCacheKeyFactory cacheKeyFactory = ServiceCacheKeyFactory.createCacheKeyFactory(this.serviceInfo, inputVarsMentioned, serviceNodeRemapper);
        Set<Var> visibleServiceSubOpVars = this.serviceInfo.getVisibleSubOpVarsScoped();
        Var batchIdxVar = VarUtilsExtra.freshVar("__idx__", visibleServiceSubOpVars);
        BatchQueryRewriterBuilder builder = BatchQueryRewriterBuilder.from(this.serviceInfo, batchIdxVar);
        if (ServiceEnhancerConstants.SELF.equals((Object)targetServiceNode)) {
            builder.setOrderRetainingUnion(true).setSequentialUnion(true);
        }
        BatchQueryRewriter rewriter = builder.build();
        QueryIterServiceBulk tmp = baseIt = new QueryIterServiceBulk(this.serviceInfo, rewriter, cacheKeyFactory, this.opExecutor, this.execCxt, inputs, this.resultSizeCache, this.cache, this.cacheMode);
        Var innerIdxVar = baseIt.getIdxVar();
        ArrayList reverseMap = new ArrayList(batchItems.keySet());
        tmp = new QueryIterConvert((QueryIterator)baseIt, b -> {
            int localId = BindingUtils.getNumber(b, innerIdxVar).intValue();
            long globalId = (Long)reverseMap.get(localId);
            Binding q = BindingUtils.project(b, (Iterator<Var>)b.vars(), innerIdxVar);
            Binding r = BindingFactory.binding((Binding)q, (Var)this.globalIdxVar, (Node)NodeValue.makeInteger((long)globalId).asNode());
            return r;
        }, this.execCxt);
        QueryIterPeek queryIter = QueryIterPeek.create((QueryIterator)tmp, (ExecutionContext)this.execCxt);
        for (Long e : batchItems.keySet()) {
            this.inputToOutputIt.put(e, queryIter);
        }
        long lastKey = (Long)batch.getItems().lastKey();
        this.inputToClose.add(lastKey);
    }

    protected void freeResources() {
        for (long inputId : this.inputToClose) {
            Closeable closable = (Closeable)this.inputToOutputIt.get(inputId);
            closable.close();
        }
        this.batchIterator.close();
    }

    protected void closeIterator() {
        this.freeResources();
        super.closeIterator();
    }
}

