/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.Table;
import com.google.common.math.LongMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NavigableMap;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.service.enhancer.claimingcache.RefFuture;
import org.apache.jena.sparql.service.enhancer.impl.Batch;
import org.apache.jena.sparql.service.enhancer.impl.BatchQueryRewriter;
import org.apache.jena.sparql.service.enhancer.impl.PartitionRequest;
import org.apache.jena.sparql.service.enhancer.impl.ServiceCacheKey;
import org.apache.jena.sparql.service.enhancer.impl.ServiceCacheKeyFactory;
import org.apache.jena.sparql.service.enhancer.impl.ServiceCacheValue;
import org.apache.jena.sparql.service.enhancer.impl.ServiceResponseCache;
import org.apache.jena.sparql.service.enhancer.impl.util.BindingUtils;
import org.apache.jena.sparql.service.enhancer.impl.util.IteratorUtils;
import org.apache.jena.sparql.service.enhancer.impl.util.QueryIterSlottedBase;
import org.apache.jena.sparql.service.enhancer.slice.api.Slice;
import org.apache.jena.sparql.service.enhancer.slice.api.SliceAccessor;

public class QueryIterWrapperCache
extends QueryIterSlottedBase {
    protected AbstractIterator<Table.Cell<Integer, Integer, Iterator<Binding>>> mergeLeftJoin;
    protected QueryIterator inputIter;
    protected ServiceResponseCache cache;
    protected int batchSize;
    protected Batch<Integer, PartitionRequest<Binding>> inputBatch;
    protected Var idxVar;
    protected Node serviceNode;
    protected ServiceCacheKeyFactory cacheKeyFactory;
    protected PartitionRequest<Binding> inputPart;
    protected long currentOffset = 0L;
    protected long processedBindingCount = 0L;
    protected Iterator<Binding> currentBatchIt;
    protected RefFuture<ServiceCacheValue> claimedCacheEntry = null;
    protected SliceAccessor<Binding[]> cacheDataAccessor = null;
    protected AbstractIterator<Long> batchOutputIdIt;

    public QueryIterWrapperCache(QueryIterator qIter, int batchSize, ServiceResponseCache cache, ServiceCacheKeyFactory cacheKeyFactory, Batch<Integer, PartitionRequest<Binding>> inputBatch, Var idxVar, Node serviceNode) {
        this.inputIter = qIter;
        this.batchSize = batchSize;
        this.cache = cache;
        this.cacheKeyFactory = cacheKeyFactory;
        this.inputBatch = inputBatch;
        this.idxVar = idxVar;
        this.serviceNode = serviceNode;
        this.currentBatchIt = null;
        this.mergeLeftJoin = IteratorUtils.partialLeftMergeJoin(Iterators.concat(inputBatch.getItems().keySet().iterator(), Arrays.asList(BatchQueryRewriter.REMOTE_END_MARKER).iterator()), qIter, outputId -> outputId, binding -> BindingUtils.getNumber(binding, idxVar).intValue());
    }

    protected Binding moveToNext() {
        Binding result;
        block3: {
            if (this.currentBatchIt == null) {
                this.setupForNextLhsBinding();
                this.currentBatchIt = Collections.emptyIterator();
            }
            do {
                if (this.currentBatchIt.hasNext()) {
                    result = this.currentBatchIt.next();
                    break block3;
                }
                this.prepareNextBatch();
            } while (this.currentBatchIt.hasNext());
            this.closeCurrentCacheResources();
            result = null;
        }
        return result;
    }

    protected void setupForNextLhsBinding() {
        Table.Cell peek;
        int outputId;
        this.closeCurrentCacheResources();
        NavigableMap<Integer, PartitionRequest<Binding>> inputs = this.inputBatch.getItems();
        if (this.mergeLeftJoin.hasNext() && !BatchQueryRewriter.isRemoteEndMarker(outputId = ((Integer)(peek = (Table.Cell)this.mergeLeftJoin.peek()).getColumnKey()).intValue())) {
            this.inputPart = (PartitionRequest)inputs.get(outputId);
            Binding inputBinding = this.inputPart.getPartitionKey();
            ServiceCacheKey cacheKey = this.cacheKeyFactory.createCacheKey(inputBinding);
            this.claimedCacheEntry = this.cache.getCache().claim(cacheKey);
            ServiceCacheValue c = this.claimedCacheEntry.await();
            Slice<Binding[]> slice = c.getSlice();
            this.cacheDataAccessor = slice.newSliceAccessor();
        }
    }

    public void prepareNextBatch() {
        NavigableMap<Integer, PartitionRequest<Binding>> inputs = this.inputBatch.getItems();
        Binding[] arr = new Binding[this.batchSize];
        long remainingBatchCapacity = this.batchSize;
        ArrayList<Binding> clientBatch = new ArrayList<Binding>(this.batchSize);
        while (this.mergeLeftJoin.hasNext() && remainingBatchCapacity > 0L) {
            Table.Cell cell = (Table.Cell)this.mergeLeftJoin.peek();
            int outputId = (Integer)cell.getColumnKey();
            Iterator rhs = (Iterator)cell.getValue();
            boolean isLocalEndMarker = BatchQueryRewriter.isRemoteEndMarker(outputId);
            if (isLocalEndMarker) {
                if (rhs != null) {
                    Iterators.size((Iterator)rhs);
                }
                Iterators.size(this.mergeLeftJoin);
                if (rhs == null) break;
                clientBatch.add(BindingFactory.binding((Var)this.idxVar, (Node)BatchQueryRewriter.NV_REMOTE_END_MARKER.asNode()));
                break;
            }
            this.inputPart = (PartitionRequest)inputs.get(outputId);
            int arrLen = 0;
            if (rhs != null) {
                while (rhs.hasNext() && (long)arrLen < remainingBatchCapacity) {
                    Binding rawOutputBinding = (Binding)rhs.next();
                    clientBatch.add(rawOutputBinding);
                    Binding outputBinding = BindingUtils.project(rawOutputBinding, (Iterator<Var>)rawOutputBinding.vars(), this.idxVar);
                    arr[arrLen++] = outputBinding;
                }
                remainingBatchCapacity -= (long)arrLen;
                this.processedBindingCount += (long)arrLen;
            }
            boolean isRhsExhausted = rhs == null || !rhs.hasNext();
            long inputOffset = this.inputPart.getOffset();
            long inputLimit = this.inputPart.getLimit();
            long start = inputOffset + this.currentOffset;
            long end = start + (long)arrLen;
            this.currentOffset += (long)arrLen;
            this.cacheDataAccessor.claimByOffsetRange(start, end);
            this.cacheDataAccessor.lock();
            try {
                this.cacheDataAccessor.write(start, arr, 0, arrLen);
                Slice<Binding[]> slice = this.cacheDataAccessor.getSlice();
                if (isRhsExhausted) {
                    boolean isEndKnown;
                    boolean peekedRemoteEndMarker;
                    this.mergeLeftJoin.next();
                    Table.Cell nextTuple = this.mergeLeftJoin.hasNext() ? (Table.Cell)this.mergeLeftJoin.peek() : null;
                    Integer nextKey = nextTuple != null ? (Integer)nextTuple.getColumnKey() : null;
                    boolean bl = peekedRemoteEndMarker = BatchQueryRewriter.isRemoteEndMarker(nextKey) && nextTuple.getValue() != null;
                    if (peekedRemoteEndMarker) {
                        Log.info(QueryIterWrapperCache.class, (String)"Peeked end marker - result set was not cut off");
                    }
                    boolean isKeyCompleted = nextTuple != null && nextTuple.getValue() != null;
                    isKeyCompleted = isKeyCompleted || peekedRemoteEndMarker || this.processedBindingCount == 0L;
                    long requestEnd = this.inputPart.hasLimit() ? LongMath.saturatedAdd((long)inputOffset, (long)inputLimit) : Long.MAX_VALUE;
                    boolean bl2 = isEndKnown = end < requestEnd;
                    if (isKeyCompleted) {
                        if (isEndKnown) {
                            if (this.currentOffset > 0L) {
                                slice.mutateMetaData(metaData -> metaData.setKnownSize(end));
                            } else {
                                slice.mutateMetaData(metaData -> metaData.setMaximumKnownSize(end));
                            }
                        } else {
                            slice.mutateMetaData(metaData -> metaData.setMinimumKnownSize(end));
                        }
                    } else {
                        slice.mutateMetaData(metaData -> metaData.setMinimumKnownSize(end));
                    }
                    this.currentOffset = 0L;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.cacheDataAccessor.unlock();
            }
            if (!isRhsExhausted) continue;
            this.setupForNextLhsBinding();
        }
        this.currentBatchIt = clientBatch.iterator();
    }

    protected void closeCurrentCacheResources() {
        if (this.cacheDataAccessor != null) {
            this.cacheDataAccessor.close();
            this.cacheDataAccessor = null;
        }
        if (this.claimedCacheEntry != null) {
            this.claimedCacheEntry.close();
            this.claimedCacheEntry = null;
        }
    }

    protected void closeIterator() {
        this.closeCurrentCacheResources();
        this.inputIter.close();
        super.closeIterator();
    }
}

