/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.service.enhancer.impl;

import com.google.common.collect.Iterators;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeBasedTable;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.TreeRangeSet;
import com.google.common.math.LongMath;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorCloseable;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.engine.iterator.QueryIterConvert;
import org.apache.jena.sparql.engine.iterator.QueryIterNullIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterPeek;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIteratorMapped;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.service.enhancer.claimingcache.RefFuture;
import org.apache.jena.sparql.service.enhancer.impl.BatchImpl;
import org.apache.jena.sparql.service.enhancer.impl.BatchQueryRewriter;
import org.apache.jena.sparql.service.enhancer.impl.CacheMode;
import org.apache.jena.sparql.service.enhancer.impl.Estimate;
import org.apache.jena.sparql.service.enhancer.impl.IteratorFactoryWithBuffer;
import org.apache.jena.sparql.service.enhancer.impl.OpServiceExecutor;
import org.apache.jena.sparql.service.enhancer.impl.OpServiceInfo;
import org.apache.jena.sparql.service.enhancer.impl.PartitionRequest;
import org.apache.jena.sparql.service.enhancer.impl.QueryIterWrapperCache;
import org.apache.jena.sparql.service.enhancer.impl.ServiceCacheKeyFactory;
import org.apache.jena.sparql.service.enhancer.impl.ServiceResponseCache;
import org.apache.jena.sparql.service.enhancer.impl.ServiceResultSizeCache;
import org.apache.jena.sparql.service.enhancer.impl.SliceKey;
import org.apache.jena.sparql.service.enhancer.impl.util.BindingUtils;
import org.apache.jena.sparql.service.enhancer.impl.util.QueryIterDefer;
import org.apache.jena.sparql.service.enhancer.impl.util.QueryIterSlottedBase;
import org.apache.jena.sparql.service.enhancer.slice.api.IteratorOverReadableChannel;
import org.apache.jena.sparql.service.enhancer.slice.api.ReadableChannelOverSliceAccessor;
import org.apache.jena.sparql.service.enhancer.slice.api.ReadableChannelWithLimit;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryIterServiceBulk
extends QueryIterSlottedBase {
    private static final Logger logger = LoggerFactory.getLogger(QueryIterServiceBulk.class);
    protected OpServiceInfo serviceInfo;
    protected ServiceCacheKeyFactory cacheKeyFactory;
    protected BatchQueryRewriter batchQueryRewriter;
    protected OpServiceExecutor opExecutor;
    protected ExecutionContext execCxt;
    protected List<Binding> inputs;
    protected ServiceResultSizeCache resultSizeCache;
    protected ServiceResponseCache cache;
    protected CacheMode cacheMode;
    protected Node targetService;
    protected int currentInputId = -1;
    protected int currentRangeId = -1;
    protected long currentInputIdBindingsServed;
    protected Var idxVar;
    protected int maxBufferSize = 100000;
    protected int maxSkipCount = 10000;
    protected int cacheBulkSize = 128;
    protected TreeBasedTable<Integer, Integer, Integer> inputToRangeToOutput = TreeBasedTable.create();
    protected Map<Integer, SliceKey> outputToSliceKey = new HashMap<Integer, SliceKey>();
    protected Set<SliceKey> sliceKeysForBackend = new HashSet<SliceKey>();
    protected IteratorFactoryWithBuffer.SubIterator<Binding, QueryIterator> backendIt;
    protected Map<SliceKey, QueryIterPeek> sliceKeyToIter = new HashMap<SliceKey, QueryIterPeek>();
    protected Estimate<Long> backendResultSetLimit;
    protected Set<SliceKey> sliceKeyToClose = new HashSet<SliceKey>();

    public QueryIterServiceBulk(OpServiceInfo serviceInfo, BatchQueryRewriter batchQueryRewriter, ServiceCacheKeyFactory cacheKeyFactory, OpServiceExecutor opExecutor, ExecutionContext execCxt, List<Binding> inputs, ServiceResultSizeCache resultSizeCache, ServiceResponseCache cache, CacheMode cacheMode) {
        this.serviceInfo = serviceInfo;
        this.cacheKeyFactory = cacheKeyFactory;
        this.opExecutor = opExecutor;
        this.execCxt = execCxt;
        this.inputs = inputs;
        this.resultSizeCache = resultSizeCache;
        this.cacheMode = cacheMode;
        this.cache = cache;
        this.batchQueryRewriter = batchQueryRewriter;
        this.idxVar = batchQueryRewriter.getIdxVar();
        this.targetService = serviceInfo.getServiceNode();
    }

    public Var getIdxVar() {
        return this.idxVar;
    }

    protected void advanceInput(boolean resetRangeId) {
        ++this.currentInputId;
        this.currentInputIdBindingsServed = 0L;
        if (resetRangeId) {
            this.currentRangeId = 0;
        }
    }

    protected synchronized Binding moveToNext() {
        SliceKey partKey;
        QueryIterPeek activeIt;
        Binding mergedBindingWithIdx = null;
        if (this.currentInputId < 0) {
            ++this.currentInputId;
            this.currentRangeId = 0;
            this.prepareNextBatchExec(false);
        }
        block5: while ((activeIt = this.sliceKeyToIter.get(partKey = new SliceKey(this.currentInputId, this.currentRangeId))) != null) {
            SliceKey sliceKey;
            boolean isBackendIt = this.sliceKeysForBackend.contains(partKey);
            if (isBackendIt && !activeIt.hasNext()) {
                logger.debug("Iterator ended without end marker - assuming remote result set limit reached");
                long seenBackendData = this.backendIt.getOffset();
                this.backendResultSetLimit = new Estimate<Long>(seenBackendData, true);
                if (seenBackendData <= 0L) {
                    logger.warn("Known result set limit of " + seenBackendData + " detected");
                }
                this.resultSizeCache.updateLimit(this.targetService, this.backendResultSetLimit);
                this.prepareNextBatchExec(false);
                continue;
            }
            if (this.backendResultSetLimit == null || this.currentInputIdBindingsServed >= this.backendResultSetLimit.getValue()) {
                long totalNeededBackendRowCount;
                this.backendResultSetLimit = this.resultSizeCache.getLimit(this.targetService);
                long obtainedRowCount = 0L;
                while ((totalNeededBackendRowCount = this.currentInputIdBindingsServed - this.backendResultSetLimit.getValue() + 1L) > 0L) {
                    long remainingNeededBackendRowCount = 0L;
                    if (this.backendIt != null && !this.backendResultSetLimit.isExact()) {
                        try (IteratorFactoryWithBuffer.SubIterator<Binding, QueryIterator> subIt = this.backendIt.subIteratorAtEndOfBuffer();){
                            long deliveredBackendRowCount = subIt.getOffset();
                            remainingNeededBackendRowCount = this.backendResultSetLimit.getValue() - deliveredBackendRowCount + 1L;
                            boolean isResultSetLimitReached = false;
                            while (obtainedRowCount < remainingNeededBackendRowCount) {
                                if (subIt.hasNext()) {
                                    Binding binding = (Binding)subIt.next();
                                    int inputId = this.getPartKeyFromBinding(binding).getInputId();
                                    boolean isEndMarkerSeen = BatchQueryRewriter.isRemoteEndMarker(inputId);
                                    if (isEndMarkerSeen) {
                                        Iterators.size(subIt);
                                        break;
                                    }
                                    ++obtainedRowCount;
                                    continue;
                                }
                                isResultSetLimitReached = true;
                                break;
                            }
                            long seenBackendData = subIt.getOffset();
                            this.backendResultSetLimit = new Estimate<Long>(seenBackendData, isResultSetLimitReached);
                            this.resultSizeCache.updateLimit(this.targetService, this.backendResultSetLimit);
                        }
                        if (obtainedRowCount < remainingNeededBackendRowCount) {
                            this.prepareNextBatchExec(true);
                            continue block5;
                        }
                    }
                    if (this.backendResultSetLimit.isExact() && this.currentInputIdBindingsServed >= this.backendResultSetLimit.getValue()) {
                        if (isBackendIt) {
                            int skipCount = 0;
                            while (this.backendIt.hasNext() && skipCount++ < this.maxSkipCount) {
                                Binding peek = (Binding)this.backendIt.peek();
                                int peekInputId = this.getPartKeyFromBinding(peek).getInputId();
                                if (peekInputId != this.currentInputId) {
                                    this.advanceInput(true);
                                    continue block5;
                                }
                                this.backendIt.next();
                            }
                            activeIt = null;
                            break;
                        }
                        if (activeIt != null) {
                            activeIt.close();
                        }
                        this.advanceInput(true);
                        continue block5;
                    }
                    if (this.backendIt != null) continue;
                    this.prepareNextBatchExec(true);
                    activeIt = this.sliceKeyToIter.get(partKey);
                }
            }
            if (activeIt != null && activeIt.hasNext()) {
                boolean matchesCurrentPartition;
                Binding peek = activeIt.peek();
                int peekOutputId = BindingUtils.getNumber(peek, this.idxVar).intValue();
                if (BatchQueryRewriter.isRemoteEndMarker(peekOutputId)) {
                    ++this.currentRangeId;
                    continue;
                }
                SliceKey sliceKey2 = this.outputToSliceKey.get(peekOutputId);
                if (sliceKey2 == null) {
                    throw new IllegalStateException(String.format("An output binding referred to an input id without corresponding input binding. Referenced input id %1$d, Output binding: %2$s", peekOutputId, peek));
                }
                boolean bl = matchesCurrentPartition = sliceKey2.getInputId() == this.currentInputId && sliceKey2.getRangeId() == this.currentRangeId;
                if (matchesCurrentPartition) {
                    Binding childBindingWithIdx;
                    Binding parentBinding = this.inputs.get(this.currentInputId);
                    mergedBindingWithIdx = Algebra.merge((Binding)parentBinding, (Binding)(childBindingWithIdx = activeIt.next()));
                    if (mergedBindingWithIdx != null) break;
                    continue;
                }
            }
            if (this.sliceKeyToClose.contains(sliceKey = new SliceKey(this.currentInputId, this.currentRangeId))) {
                Closeable closeable = (Closeable)this.sliceKeyToIter.get(sliceKey);
                closeable.close();
                this.sliceKeyToClose.remove(sliceKey);
            }
            this.inputToRangeToOutput.remove((Object)this.currentInputId, (Object)this.currentRangeId);
            this.sliceKeyToIter.remove(sliceKey);
            ++this.currentRangeId;
            SortedMap row = this.inputToRangeToOutput.row((Object)this.currentInputId);
            if (!row.containsKey(this.currentRangeId)) {
                this.advanceInput(true);
            }
            if (this.inputToRangeToOutput.containsRow((Object)this.currentInputId)) continue;
            break;
        }
        Binding result = null;
        if (mergedBindingWithIdx != null) {
            ++this.currentInputIdBindingsServed;
            int outputId = BindingUtils.getNumber(mergedBindingWithIdx, this.idxVar).intValue();
            SliceKey pk = this.outputToSliceKey.get(outputId);
            int inputId = pk.getInputId();
            Binding tmp = BindingUtils.project(mergedBindingWithIdx, (Iterator<Var>)mergedBindingWithIdx.vars(), this.idxVar);
            result = BindingFactory.binding((Binding)tmp, (Var)this.idxVar, (Node)NodeValue.makeInteger((long)inputId).asNode());
        }
        if (result == null) {
            this.freeResources();
        }
        return result;
    }

    public SliceKey getPartKeyFromBinding(Binding binding) {
        int peekOutputId = BindingUtils.getNumber(binding, this.idxVar).intValue();
        SliceKey result = BatchQueryRewriter.isRemoteEndMarker(peekOutputId) ? new SliceKey(BatchQueryRewriter.REMOTE_END_MARKER, 0) : this.outputToSliceKey.get(peekOutputId);
        return result;
    }

    protected void freeResources() {
        if (this.backendIt != null) {
            this.backendIt.close();
        }
        for (SliceKey partKey : this.sliceKeyToClose) {
            Closeable closeable = (Closeable)this.sliceKeyToIter.get(partKey);
            closeable.close();
        }
        this.sliceKeyToClose.clear();
        this.inputToRangeToOutput.clear();
        this.outputToSliceKey.clear();
        this.sliceKeyToIter.clear();
        this.sliceKeysForBackend.clear();
    }

    public synchronized void closeIterator() {
        this.freeResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void prepareNextBatchExec(boolean bypassCacheOnFirstInput) {
        this.freeResources();
        backendRequests = BatchImpl.forInteger();
        serviceDescription = this.resultSizeCache.getLimit(this.targetService);
        resultSetLimit = serviceDescription.getValue();
        isExact = serviceDescription.isExact();
        nextAllocOutputId = 0;
        batchSize = this.inputs.size();
        if (QueryIterServiceBulk.logger.isInfoEnabled()) {
            QueryIterServiceBulk.logger.info("Schedule for current batch:");
        }
        rangeId = this.currentRangeId;
        for (inputId = this.currentInputId; inputId < batchSize; ++inputId) {
            block31: {
                isFirstInput = inputId == this.currentInputId;
                displacement = isFirstInput != false && bypassCacheOnFirstInput == false ? this.currentInputIdBindingsServed : 0L;
                inputBinding = this.inputs.get(inputId);
                slice = null;
                lock = null;
                cacheValueRef = null;
                if (this.cache != null) {
                    cacheKey = this.cacheKeyFactory.createCacheKey(inputBinding);
                    cacheValueRef = this.cache.getCache().claim(cacheKey);
                    serviceCacheValue = cacheValueRef.await();
                    slice = serviceCacheValue.getSlice();
                    if (CacheMode.CLEAR.equals((Object)this.cacheMode)) {
                        slice.clear();
                    }
                    lock = slice.getReadWriteLock().readLock();
                    if (QueryIterServiceBulk.logger.isDebugEnabled()) {
                        QueryIterServiceBulk.logger.debug("Created cache key: " + String.valueOf(cacheKey));
                    }
                    lock.lock();
                }
                try {
                    if (slice != null) {
                        loadedRanges = slice.getLoadedRanges();
                        knownSize = slice.getKnownSize();
                    } else {
                        loadedRanges = TreeRangeSet.create();
                        knownSize = -1L;
                    }
                    start = this.serviceInfo.getOffset();
                    if (start == -9223372036854775808L) {
                        start = 0L;
                    }
                    if ((baseLimit = this.serviceInfo.getLimit()) < 0L) {
                        baseLimit = 0x7FFFFFFFFFFFFFFFL;
                    }
                    limit = baseLimit;
                    if (isExact && baseLimit >= 0L) {
                        limit = Math.min(limit, resultSetLimit);
                    }
                    if (displacement != 0L) {
                        start += displacement;
                        if (limit != 0x7FFFFFFFFFFFFFFFL) {
                            limit -= displacement;
                        }
                    }
                    max = knownSize < 0L ? 0x7FFFFFFFFFFFFFFFL : knownSize;
                    end = limit == 0x7FFFFFFFFFFFFFFFL ? max : LongMath.saturatedAdd((long)start, (long)limit);
                    end = Math.min(end, max);
                    requestedRange = end == 0x7FFFFFFFFFFFFFFFL ? Range.atLeast((Comparable)Long.valueOf(start)) : Range.closedOpen((Comparable)Long.valueOf(start), (Comparable)Long.valueOf(end));
                    allRanges = TreeRangeMap.create();
                    if (bypassCacheOnFirstInput && isFirstInput) {
                        allRanges.put(requestedRange, (Object)false);
                    } else {
                        presentRanges = loadedRanges.subRangeSet(requestedRange);
                        absentRanges = loadedRanges.complement().subRangeSet(requestedRange);
                        presentRanges.asRanges().forEach((Consumer<Range>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$prepareNextBatchExec$0(com.google.common.collect.RangeMap com.google.common.collect.Range ), (Lcom/google/common/collect/Range;)V)((RangeMap)allRanges));
                        absentRanges.asRanges().forEach((Consumer<Range>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$prepareNextBatchExec$1(com.google.common.collect.RangeMap com.google.common.collect.Range ), (Lcom/google/common/collect/Range;)V)((RangeMap)allRanges));
                    }
                    if (QueryIterServiceBulk.logger.isInfoEnabled()) {
                        QueryIterServiceBulk.logger.info("input " + inputId + ": " + allRanges.toString().replace("false", "fetch").replace("true", "cached"));
                    }
                    if ((mapOfRanges = allRanges.asMapOfRanges()).isEmpty()) {
                        if (cacheValueRef != null) {
                            cacheValueRef.close();
                        }
                        sliceKey = new SliceKey(inputId, rangeId);
                        it = QueryIterPeek.create((QueryIterator)new QueryIterNullIterator(this.execCxt), (ExecutionContext)this.execCxt);
                        this.sliceKeyToIter.put(sliceKey, it);
                        this.sliceKeyToClose.add(sliceKey);
                        this.inputToRangeToOutput.put((Object)inputId, (Object)rangeId, (Object)nextAllocOutputId);
                        this.outputToSliceKey.put(nextAllocOutputId, sliceKey);
                        ++rangeId;
                        ++nextAllocOutputId;
                        break block31;
                    }
                    rangeIt = mapOfRanges.entrySet().iterator();
                    finalCacheValueRef = cacheValueRef;
                    usesCacheRead = false;
                    while (rangeIt.hasNext()) {
                        block33: {
                            block32: {
                                sliceKey = new SliceKey(inputId, rangeId);
                                f = rangeIt.next();
                                range = (Range)f.getKey();
                                isLoaded = (Boolean)f.getValue();
                                lo = (Long)range.lowerEndpoint();
                                hi = range.hasUpperBound() != false ? (Long)range.upperEndpoint() : 0x7FFFFFFFFFFFFFFFL;
                                v0 = lim = hi == 0x7FFFFFFFFFFFFFFFL ? 0x7FFFFFFFFFFFFFFFL : hi - lo;
                                if (!isLoaded) break block32;
                                usesCacheRead = true;
                                accessor = slice.newSliceAccessor();
                                accessor.addEvictionGuard((Range<Long>)Range.closedOpen((Comparable)Long.valueOf(lo), (Comparable)Long.valueOf(hi)));
                                channel = new ReadableChannelWithLimit<Binding[]>(new ReadableChannelOverSliceAccessor<Binding[]>(accessor, lo), lim);
                                baseIt = new IteratorOverReadableChannel<T>(channel.getArrayOps(), channel, 4096);
                                if (rangeIt.hasNext()) ** GOTO lbl100
                                if (finalCacheValueRef == null) {
lbl100:
                                    // 2 sources

                                    v1 = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, close(), ()V)(baseIt);
                                } else {
                                    v1 = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$prepareNextBatchExec$2(org.apache.jena.atlas.iterator.IteratorCloseable org.apache.jena.sparql.service.enhancer.claimingcache.RefFuture ), ()V)(baseIt, finalCacheValueRef);
                                }
                                cacheEntryCloseAction = v1;
                                qIterA = QueryIterPlainWrapper.create((Iterator)Iter.onClose(baseIt, (Runnable)cacheEntryCloseAction), (ExecutionContext)this.execCxt);
                                normedToScoped = this.serviceInfo.getVisibleSubOpVarsNormedToScoped();
                                qIterA = new QueryIteratorMapped(qIterA, normedToScoped);
                                idxVarValue = nextAllocOutputId;
                                qIterB = new QueryIterConvert(qIterA, (QueryIterConvert.Converter)LambdaMetafactory.metafactory(null, null, null, (Lorg/apache/jena/sparql/engine/binding/Binding;)Lorg/apache/jena/sparql/engine/binding/Binding;, lambda$prepareNextBatchExec$3(long org.apache.jena.sparql.engine.binding.Binding ), (Lorg/apache/jena/sparql/engine/binding/Binding;)Lorg/apache/jena/sparql/engine/binding/Binding;)((QueryIterServiceBulk)this, (long)idxVarValue), this.execCxt);
                                it = QueryIterPeek.create((QueryIterator)qIterB, (ExecutionContext)this.execCxt);
                                this.sliceKeyToIter.put(sliceKey, it);
                                this.sliceKeyToClose.add(sliceKey);
                                break block33;
                            }
                            request = new PartitionRequest<Binding>(nextAllocOutputId, inputBinding, lo, lim);
                            backendRequests.put(nextAllocOutputId, request);
                            this.sliceKeysForBackend.add(sliceKey);
                        }
                        this.inputToRangeToOutput.put((Object)inputId, (Object)rangeId, (Object)nextAllocOutputId);
                        this.outputToSliceKey.put(nextAllocOutputId, sliceKey);
                        ++rangeId;
                        ++nextAllocOutputId;
                    }
                    if (!usesCacheRead && finalCacheValueRef != null) {
                        finalCacheValueRef.close();
                    }
                }
                finally {
                    if (lock != null) {
                        lock.unlock();
                    }
                }
            }
            rangeId = 0;
        }
        if (!backendRequests.isEmpty()) {
            rewrite = this.batchQueryRewriter.rewrite(backendRequests);
            newSubOp = rewrite.getOp();
            substitutedOp = new OpService(this.targetService, newSubOp, this.serviceInfo.getOpService().getSilent());
            qIterSupplier = (Supplier<QueryIterator>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$prepareNextBatchExec$4(org.apache.jena.sparql.algebra.op.OpService ), ()Lorg/apache/jena/sparql/engine/QueryIterator;)((QueryIterServiceBulk)this, (OpService)substitutedOp);
            qIter /* !! */  = new QueryIterDefer(qIterSupplier);
            if (this.cache != null) {
                qIter /* !! */  = new QueryIterWrapperCache((QueryIterator)qIter /* !! */ , this.cacheBulkSize, this.cache, this.cacheKeyFactory, backendRequests, this.idxVar, this.targetService);
            }
            qIter /* !! */  = QueryIter.map((QueryIterator)qIter /* !! */ , rewrite.getRenames());
            backendItPrimary = IteratorFactoryWithBuffer.wrap(qIter /* !! */ );
            jenaIt = Iter.onClose(backendItPrimary, (Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, close(), ()V)((QueryIterator)qIter /* !! */ ));
            iter = QueryIterPlainWrapper.create((Iterator)jenaIt, (ExecutionContext)this.execCxt);
            frontIter = QueryIterPeek.create((QueryIterator)iter, (ExecutionContext)this.execCxt);
            for (Integer outputId : backendRequests.getItems().keySet()) {
                sliceKey = this.outputToSliceKey.get(outputId);
                this.sliceKeyToIter.put(sliceKey, frontIter);
            }
            lastOutputId = (Integer)backendRequests.getItems().lastKey();
            lastSliceKey = this.outputToSliceKey.get(lastOutputId);
            this.sliceKeyToClose.add(lastSliceKey);
            this.backendIt = backendItPrimary;
            if (bypassCacheOnFirstInput) {
                i = 0;
                while ((long)i < this.currentInputIdBindingsServed) {
                    if (this.backendIt.hasNext()) {
                        this.backendIt.next();
                    }
                    ++i;
                }
            }
        }
    }

    protected int getOutputId(Binding binding) {
        int result = BindingUtils.getNumber(binding, this.idxVar).intValue();
        return result;
    }

    protected SliceKey getSliceKeyForOutputId(int outputId) {
        return this.outputToSliceKey.get(outputId);
    }

    private /* synthetic */ QueryIterator lambda$prepareNextBatchExec$4(OpService substitutedOp) {
        QueryIterator r = this.opExecutor.exec(substitutedOp);
        return r;
    }

    private /* synthetic */ Binding lambda$prepareNextBatchExec$3(long idxVarValue, Binding b) {
        return BindingFactory.binding((Binding)b, (Var)this.idxVar, (Node)NodeFactoryExtra.intToNode((long)idxVarValue));
    }

    private static /* synthetic */ void lambda$prepareNextBatchExec$2(IteratorCloseable baseIt, RefFuture finalCacheValueRef) {
        baseIt.close();
        finalCacheValueRef.close();
    }

    private static /* synthetic */ void lambda$prepareNextBatchExec$1(RangeMap allRanges, Range r) {
        allRanges.put(r, (Object)false);
    }

    private static /* synthetic */ void lambda$prepareNextBatchExec$0(RangeMap allRanges, Range r) {
        allRanges.put(r, (Object)true);
    }
}

